/// <reference types="node" />
import * as common from './common';
import { CreateOptions } from './sign';
import { ReadOptions } from './encrypt';
export declare const MAC0Tag = 17;
export declare const MACTag = 97;
export declare type MACstructure = [
    'MAC0' | 'MAC1',
    any,
    string,
    string
];
export declare function aesCbcMac(key: Uint8Array, msg: Uint8Array, len: number): Promise<Buffer>;
export declare type Recipient = {
    key: Buffer | ArrayBuffer;
    u?: common.HeaderPU["u"];
};
export declare type Recipients = Recipient | Recipient[];
export declare type HMACHeader = {
    p: common.HeaderPU["p"];
    u?: common.HeaderPU["u"];
};
export declare function create(headers: HMACHeader, payload: any, recipients: Recipients, externalAAD?: ArrayBuffer | Buffer, options?: CreateOptions): Promise<any>;
export declare function read(data: ArrayBuffer | Uint8Array, key: Buffer | ArrayBuffer, externalAAD?: Buffer | ArrayBuffer, options?: ReadOptions): Promise<any>;
