'use strict'

var camel = require('camel-case')
var card = require('./card')

var cvcRegex = /^\d{3,4}$/

exports.isValid = function (cvc, type) {
  if (typeof cvc !== 'string') return false
  if (!cvcRegex.test(cvc)) return false
  if (!type) return true
  return card.types[camel(type)].cvcLength === cvc.length
}
