'use strict'

var luhn = require('fast-luhn')
var types = require('./types')

module.exports = {
  types: types,
  parse: parseCard,
  format: formatCard,
  type: cardType,
  luhn: luhn,
  isValid: isCardValid
}

function parseCard (number) {
  if (typeof number !== 'string') return ''
  return number.replace(/[^\d]/g, '')
}

function formatCard (number, separator) {
  var type = getType(number, true)
  if (!type) return number
  return type.group(number).join(separator || ' ')
}

function cardType (number, eager) {
  var type = getType(number, eager)
  return type ? type.name : undefined
}

function isCardValid (number, type) {
  if (type) {
    type = types.get(type)
  } else {
    type = getType(number)
  }
  if (!type) return false
  return (!type.luhn || luhn(number)) && type.test(number)
}

function getType (number, eager) {
  return types.find(function (type) {
    return type.test(number, eager)
  })
}
