(function webpackUniversalModuleDefinition(root, factory) {
    if (typeof exports === "object" && typeof module === "object") module.exports = factory(); else if (typeof define === "function" && define.amd) define("xdsweakmap", [], factory); else if (typeof exports === "object") exports["xdsweakmap"] = factory(); else root["xdsweakmap"] = factory();
})(this, function() {
    return function(modules) {
        var installedModules = {};
        function __webpack_require__(moduleId) {
            if (installedModules[moduleId]) return installedModules[moduleId].exports;
            var module = installedModules[moduleId] = {
                exports: {},
                id: moduleId,
                loaded: false
            };
            modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
            module.loaded = true;
            return module.exports;
        }
        __webpack_require__.m = modules;
        __webpack_require__.c = installedModules;
        __webpack_require__.p = "";
        return __webpack_require__(0);
    }({
        0: function(module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            var _interface = __webpack_require__("./src/interface.js");
            Object.keys(_interface).forEach(function(key) {
                if (key === "default" || key === "__esModule") return;
                Object.defineProperty(exports, key, {
                    enumerable: true,
                    get: function get() {
                        return _interface[key];
                    }
                });
            });
            var INTERFACE = _interopRequireWildcard(_interface);
            function _interopRequireWildcard(obj) {
                if (obj && obj.__esModule) {
                    return obj;
                } else {
                    var newObj = {};
                    if (obj != null) {
                        for (var key in obj) {
                            if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                        }
                    }
                    newObj["default"] = obj;
                    return newObj;
                }
            }
            exports["default"] = INTERFACE;
        },
        "./src/interface.js": function(module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            var _weakmap = __webpack_require__("./src/weakmap.js");
            Object.defineProperty(exports, "WeakMap", {
                enumerable: true,
                get: function get() {
                    return _weakmap.CrossDomainSafeWeakMap;
                }
            });
        },
        "./src/weakmap.js": function(module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.CrossDomainSafeWeakMap = undefined;
            var _createClass = function() {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }
                return function(Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();
            var _src = __webpack_require__("./node_modules/cross-domain-utils/src/index.js");
            var _native = __webpack_require__("./src/native.js");
            var _util = __webpack_require__("./src/util.js");
            function _classCallCheck(instance, Constructor) {
                if (!(instance instanceof Constructor)) {
                    throw new TypeError("Cannot call a class as a function");
                }
            }
            var defineProperty = Object.defineProperty;
            var counter = Date.now() % 1e9;
            var CrossDomainSafeWeakMap = exports.CrossDomainSafeWeakMap = function() {
                function CrossDomainSafeWeakMap() {
                    _classCallCheck(this, CrossDomainSafeWeakMap);
                    counter += 1;
                    this.name = "__weakmap_" + (Math.random() * 1e9 >>> 0) + "__" + counter;
                    if ((0, _native.hasNativeWeakMap)()) {
                        try {
                            this.weakmap = new window.WeakMap();
                        } catch (err) {}
                    }
                    this.keys = [];
                    this.values = [];
                }
                _createClass(CrossDomainSafeWeakMap, [ {
                    key: "_cleanupClosedWindows",
                    value: function _cleanupClosedWindows() {
                        var weakmap = this.weakmap;
                        var keys = this.keys;
                        for (var i = 0; i < keys.length; i++) {
                            var value = keys[i];
                            if ((0, _src.isWindow)(value) && (0, _src.isWindowClosed)(value)) {
                                if (weakmap) {
                                    try {
                                        weakmap["delete"](value);
                                    } catch (err) {}
                                }
                                keys.splice(i, 1);
                                this.values.splice(i, 1);
                                i -= 1;
                            }
                        }
                    }
                }, {
                    key: "isSafeToReadWrite",
                    value: function isSafeToReadWrite(key) {
                        if ((0, _src.isWindow)(key)) {
                            return false;
                        }
                        try {
                            (0, _util.noop)(key && key.self);
                            (0, _util.noop)(key && key[this.name]);
                        } catch (err) {
                            return false;
                        }
                        return true;
                    }
                }, {
                    key: "set",
                    value: function set(key, value) {
                        if (!key) {
                            throw new Error("WeakMap expected key");
                        }
                        var weakmap = this.weakmap;
                        if (weakmap) {
                            try {
                                weakmap.set(key, value);
                            } catch (err) {
                                delete this.weakmap;
                            }
                        }
                        if (!this.isSafeToReadWrite(key)) {
                            this._cleanupClosedWindows();
                            var keys = this.keys;
                            var values = this.values;
                            var index = (0, _util.safeIndexOf)(keys, key);
                            if (index === -1) {
                                keys.push(key);
                                values.push(value);
                            } else {
                                values[index] = value;
                            }
                        } else {
                            var name = this.name;
                            var entry = key[name];
                            if (entry && entry[0] === key) {
                                entry[1] = value;
                            } else {
                                defineProperty(key, name, {
                                    value: [ key, value ],
                                    writable: true
                                });
                            }
                        }
                    }
                }, {
                    key: "get",
                    value: function get(key) {
                        if (!key) {
                            throw new Error("WeakMap expected key");
                        }
                        var weakmap = this.weakmap;
                        if (weakmap) {
                            try {
                                if (weakmap.has(key)) {
                                    return weakmap.get(key);
                                }
                            } catch (err) {
                                delete this.weakmap;
                            }
                        }
                        if (!this.isSafeToReadWrite(key)) {
                            this._cleanupClosedWindows();
                            var keys = this.keys;
                            var index = (0, _util.safeIndexOf)(keys, key);
                            if (index === -1) {
                                return;
                            }
                            return this.values[index];
                        } else {
                            var entry = key[this.name];
                            if (entry && entry[0] === key) {
                                return entry[1];
                            }
                        }
                    }
                }, {
                    key: "delete",
                    value: function _delete(key) {
                        if (!key) {
                            throw new Error("WeakMap expected key");
                        }
                        var weakmap = this.weakmap;
                        if (weakmap) {
                            try {
                                weakmap["delete"](key);
                            } catch (err) {
                                delete this.weakmap;
                            }
                        }
                        if (!this.isSafeToReadWrite(key)) {
                            this._cleanupClosedWindows();
                            var keys = this.keys;
                            var index = (0, _util.safeIndexOf)(keys, key);
                            if (index !== -1) {
                                keys.splice(index, 1);
                                this.values.splice(index, 1);
                            }
                        } else {
                            var entry = key[this.name];
                            if (entry && entry[0] === key) {
                                entry[0] = entry[1] = undefined;
                            }
                        }
                    }
                }, {
                    key: "has",
                    value: function has(key) {
                        if (!key) {
                            throw new Error("WeakMap expected key");
                        }
                        var weakmap = this.weakmap;
                        if (weakmap) {
                            try {
                                return weakmap.has(key);
                            } catch (err) {
                                delete this.weakmap;
                            }
                        }
                        if (!this.isSafeToReadWrite(key)) {
                            this._cleanupClosedWindows();
                            var index = (0, _util.safeIndexOf)(this.keys, key);
                            return index !== -1;
                        } else {
                            var entry = key[this.name];
                            if (entry && entry[0] === key) {
                                return true;
                            }
                            return false;
                        }
                    }
                } ]);
                return CrossDomainSafeWeakMap;
            }();
        },
        "./node_modules/cross-domain-utils/src/index.js": function(module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.getActualDomain = getActualDomain;
            exports.getDomain = getDomain;
            exports.isBlankDomain = isBlankDomain;
            exports.isActuallySameDomain = isActuallySameDomain;
            exports.isSameDomain = isSameDomain;
            exports.getParent = getParent;
            exports.getOpener = getOpener;
            exports.getParents = getParents;
            exports.isAncestorParent = isAncestorParent;
            exports.getFrames = getFrames;
            exports.getAllChildFrames = getAllChildFrames;
            exports.getTop = getTop;
            exports.getAllFramesInWindow = getAllFramesInWindow;
            exports.isTop = isTop;
            exports.isFrameWindowClosed = isFrameWindowClosed;
            exports.isWindowClosed = isWindowClosed;
            exports.linkFrameWindow = linkFrameWindow;
            exports.getUserAgent = getUserAgent;
            exports.getFrameByName = getFrameByName;
            exports.findChildFrameByName = findChildFrameByName;
            exports.findFrameByName = findFrameByName;
            exports.isParent = isParent;
            exports.isOpener = isOpener;
            exports.getAncestor = getAncestor;
            exports.getAncestors = getAncestors;
            exports.isAncestor = isAncestor;
            exports.isPopup = isPopup;
            exports.isIframe = isIframe;
            exports.isFullpage = isFullpage;
            exports.getDistanceFromTop = getDistanceFromTop;
            exports.getNthParent = getNthParent;
            exports.getNthParentFromTop = getNthParentFromTop;
            exports.isSameTopWindow = isSameTopWindow;
            exports.matchDomain = matchDomain;
            exports.getDomainFromUrl = getDomainFromUrl;
            exports.onCloseWindow = onCloseWindow;
            exports.isWindow = isWindow;
            var _util = __webpack_require__("./node_modules/cross-domain-utils/src/util.js");
            var CONSTANTS = {
                MOCK_PROTOCOL: "mock:",
                FILE_PROTOCOL: "file:",
                WILDCARD: "*"
            };
            var IE_WIN_ACCESS_ERROR = "Call was rejected by callee.\r\n";
            function getActualDomain(win) {
                var location = win.location;
                if (!location) {
                    throw new Error("Can not read window location");
                }
                var protocol = location.protocol;
                if (!protocol) {
                    throw new Error("Can not read window protocol");
                }
                if (protocol === CONSTANTS.FILE_PROTOCOL) {
                    return "file://";
                }
                var host = location.host;
                if (!host) {
                    throw new Error("Can not read window host");
                }
                return protocol + "//" + host;
            }
            function getDomain(win) {
                win = win || window;
                var domain = getActualDomain(win);
                if (domain && win.mockDomain && win.mockDomain.indexOf(CONSTANTS.MOCK_PROTOCOL) === 0) {
                    return win.mockDomain;
                }
                return domain;
            }
            function isBlankDomain(win) {
                try {
                    if (!win.location.href) {
                        return true;
                    }
                    if (win.location.href === "about:blank") {
                        return true;
                    }
                } catch (err) {}
                return false;
            }
            function isActuallySameDomain(win) {
                try {
                    var desc = Object.getOwnPropertyDescriptor(win, "location");
                    if (desc && desc.enumerable === false) {
                        return false;
                    }
                } catch (err) {}
                try {
                    if (isBlankDomain(win)) {
                        return true;
                    }
                    if (getActualDomain(win) === getActualDomain(window)) {
                        return true;
                    }
                } catch (err) {}
                return false;
            }
            function isSameDomain(win) {
                if (!isActuallySameDomain(win)) {
                    return false;
                }
                try {
                    if (isBlankDomain(win)) {
                        return true;
                    }
                    if (getDomain(window) === getDomain(win)) {
                        return true;
                    }
                } catch (err) {}
                return false;
            }
            function getParent(win) {
                if (!win) {
                    return;
                }
                try {
                    if (win.parent && win.parent !== win) {
                        return win.parent;
                    }
                } catch (err) {
                    return;
                }
            }
            function getOpener(win) {
                if (!win) {
                    return;
                }
                if (getParent(win)) {
                    return;
                }
                try {
                    return win.opener;
                } catch (err) {
                    return;
                }
            }
            function getParents(win) {
                var result = [];
                try {
                    while (win.parent !== win) {
                        result.push(win.parent);
                        win = win.parent;
                    }
                } catch (err) {}
                return result;
            }
            function isAncestorParent(parent, child) {
                if (!parent || !child) {
                    return false;
                }
                var childParent = getParent(child);
                if (childParent) {
                    return childParent === parent;
                }
                if (getParents(child).indexOf(parent) !== -1) {
                    return true;
                }
                return false;
            }
            function getFrames(win) {
                var result = [];
                var frames = void 0;
                try {
                    frames = win.frames;
                } catch (err) {
                    frames = win;
                }
                var len = void 0;
                try {
                    len = frames.length;
                } catch (err) {}
                if (len === 0) {
                    return result;
                }
                if (len) {
                    for (var i = 0; i < len; i++) {
                        var frame = void 0;
                        try {
                            frame = frames[i];
                        } catch (err) {
                            continue;
                        }
                        result.push(frame);
                    }
                    return result;
                }
                for (var _i = 0; _i < 100; _i++) {
                    var _frame = void 0;
                    try {
                        _frame = frames[_i];
                    } catch (err) {
                        return result;
                    }
                    if (!_frame) {
                        return result;
                    }
                    result.push(_frame);
                }
                return result;
            }
            function getAllChildFrames(win) {
                var result = [];
                for (var _iterator = getFrames(win), _isArray = Array.isArray(_iterator), _i2 = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator](); ;) {
                    var _ref;
                    if (_isArray) {
                        if (_i2 >= _iterator.length) break;
                        _ref = _iterator[_i2++];
                    } else {
                        _i2 = _iterator.next();
                        if (_i2.done) break;
                        _ref = _i2.value;
                    }
                    var frame = _ref;
                    result.push(frame);
                    for (var _iterator2 = getAllChildFrames(frame), _isArray2 = Array.isArray(_iterator2), _i3 = 0, _iterator2 = _isArray2 ? _iterator2 : _iterator2[Symbol.iterator](); ;) {
                        var _ref2;
                        if (_isArray2) {
                            if (_i3 >= _iterator2.length) break;
                            _ref2 = _iterator2[_i3++];
                        } else {
                            _i3 = _iterator2.next();
                            if (_i3.done) break;
                            _ref2 = _i3.value;
                        }
                        var childFrame = _ref2;
                        result.push(childFrame);
                    }
                }
                return result;
            }
            function getTop(win) {
                if (!win) {
                    return;
                }
                try {
                    if (win.top) {
                        return win.top;
                    }
                } catch (err) {}
                if (getParent(win) === win) {
                    return win;
                }
                try {
                    if (isAncestorParent(window, win) && window.top) {
                        return window.top;
                    }
                } catch (err) {}
                try {
                    if (isAncestorParent(win, window) && window.top) {
                        return window.top;
                    }
                } catch (err) {}
                for (var _iterator3 = getAllChildFrames(win), _isArray3 = Array.isArray(_iterator3), _i4 = 0, _iterator3 = _isArray3 ? _iterator3 : _iterator3[Symbol.iterator](); ;) {
                    var _ref3;
                    if (_isArray3) {
                        if (_i4 >= _iterator3.length) break;
                        _ref3 = _iterator3[_i4++];
                    } else {
                        _i4 = _iterator3.next();
                        if (_i4.done) break;
                        _ref3 = _i4.value;
                    }
                    var frame = _ref3;
                    try {
                        if (frame.top) {
                            return frame.top;
                        }
                    } catch (err) {}
                    if (getParent(frame) === frame) {
                        return frame;
                    }
                }
            }
            function getAllFramesInWindow(win) {
                var top = getTop(win);
                return getAllChildFrames(top).concat(top);
            }
            function isTop(win) {
                return win === getTop(win);
            }
            function isFrameWindowClosed(frame) {
                if (!frame.contentWindow) {
                    return true;
                }
                if (!frame.parentNode) {
                    return true;
                }
                var doc = frame.ownerDocument;
                if (doc && doc.body && !doc.body.contains(frame)) {
                    return true;
                }
                return false;
            }
            function safeIndexOf(collection, item) {
                for (var i = 0; i < collection.length; i++) {
                    try {
                        if (collection[i] === item) {
                            return i;
                        }
                    } catch (err) {}
                }
                return -1;
            }
            var iframeWindows = [];
            var iframeFrames = [];
            function isWindowClosed(win) {
                var allowMock = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
                try {
                    if (win === window) {
                        return false;
                    }
                } catch (err) {
                    return true;
                }
                try {
                    if (!win) {
                        return true;
                    }
                } catch (err) {
                    return true;
                }
                try {
                    if (win.closed) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return false;
                    }
                    return true;
                }
                if (allowMock && isSameDomain(win)) {
                    try {
                        if (win.mockclosed) {
                            return true;
                        }
                    } catch (err) {}
                }
                try {
                    if (!win.parent || !win.top) {
                        return true;
                    }
                } catch (err) {}
                try {
                    (0, _util.noop)(win === win);
                } catch (err) {
                    return true;
                }
                var iframeIndex = safeIndexOf(iframeWindows, win);
                if (iframeIndex !== -1) {
                    var frame = iframeFrames[iframeIndex];
                    if (frame && isFrameWindowClosed(frame)) {
                        return true;
                    }
                }
                return false;
            }
            function cleanIframes() {
                for (var i = 0; i < iframeFrames.length; i++) {
                    if (isFrameWindowClosed(iframeFrames[i])) {
                        iframeFrames.splice(i, 1);
                        iframeWindows.splice(i, 1);
                    }
                }
                for (var _i5 = 0; _i5 < iframeWindows.length; _i5++) {
                    if (isWindowClosed(iframeWindows[_i5])) {
                        iframeFrames.splice(_i5, 1);
                        iframeWindows.splice(_i5, 1);
                    }
                }
            }
            function linkFrameWindow(frame) {
                cleanIframes();
                if (frame && frame.contentWindow) {
                    try {
                        iframeWindows.push(frame.contentWindow);
                        iframeFrames.push(frame);
                    } catch (err) {}
                }
            }
            function getUserAgent(win) {
                win = win || window;
                return win.navigator.mockUserAgent || win.navigator.userAgent;
            }
            function getFrameByName(win, name) {
                var winFrames = getFrames(win);
                for (var _iterator4 = winFrames, _isArray4 = Array.isArray(_iterator4), _i6 = 0, _iterator4 = _isArray4 ? _iterator4 : _iterator4[Symbol.iterator](); ;) {
                    var _ref4;
                    if (_isArray4) {
                        if (_i6 >= _iterator4.length) break;
                        _ref4 = _iterator4[_i6++];
                    } else {
                        _i6 = _iterator4.next();
                        if (_i6.done) break;
                        _ref4 = _i6.value;
                    }
                    var childFrame = _ref4;
                    try {
                        if (isSameDomain(childFrame) && childFrame.name === name && winFrames.indexOf(childFrame) !== -1) {
                            return childFrame;
                        }
                    } catch (err) {}
                }
                try {
                    if (winFrames.indexOf(win.frames[name]) !== -1) {
                        return win.frames[name];
                    }
                } catch (err) {}
                try {
                    if (winFrames.indexOf(win[name]) !== -1) {
                        return win[name];
                    }
                } catch (err) {}
            }
            function findChildFrameByName(win, name) {
                var frame = getFrameByName(win, name);
                if (frame) {
                    return frame;
                }
                for (var _iterator5 = getFrames(win), _isArray5 = Array.isArray(_iterator5), _i7 = 0, _iterator5 = _isArray5 ? _iterator5 : _iterator5[Symbol.iterator](); ;) {
                    var _ref5;
                    if (_isArray5) {
                        if (_i7 >= _iterator5.length) break;
                        _ref5 = _iterator5[_i7++];
                    } else {
                        _i7 = _iterator5.next();
                        if (_i7.done) break;
                        _ref5 = _i7.value;
                    }
                    var childFrame = _ref5;
                    var namedFrame = findChildFrameByName(childFrame, name);
                    if (namedFrame) {
                        return namedFrame;
                    }
                }
            }
            function findFrameByName(win, name) {
                var frame = void 0;
                frame = getFrameByName(win, name);
                if (frame) {
                    return frame;
                }
                var top = getTop(win) || win;
                return findChildFrameByName(top, name);
            }
            function isParent(win, frame) {
                var frameParent = getParent(frame);
                if (frameParent) {
                    return frameParent === win;
                }
                for (var _iterator6 = getFrames(win), _isArray6 = Array.isArray(_iterator6), _i8 = 0, _iterator6 = _isArray6 ? _iterator6 : _iterator6[Symbol.iterator](); ;) {
                    var _ref6;
                    if (_isArray6) {
                        if (_i8 >= _iterator6.length) break;
                        _ref6 = _iterator6[_i8++];
                    } else {
                        _i8 = _iterator6.next();
                        if (_i8.done) break;
                        _ref6 = _i8.value;
                    }
                    var childFrame = _ref6;
                    if (childFrame === frame) {
                        return true;
                    }
                }
                return false;
            }
            function isOpener(parent, child) {
                return parent === getOpener(child);
            }
            function getAncestor(win) {
                win = win || window;
                var opener = getOpener(win);
                if (opener) {
                    return opener;
                }
                var parent = getParent(win);
                if (parent) {
                    return parent;
                }
            }
            function getAncestors(win) {
                var results = [];
                var ancestor = win;
                while (ancestor) {
                    ancestor = getAncestor(ancestor);
                    if (ancestor) {
                        results.push(ancestor);
                    }
                }
                return results;
            }
            function isAncestor(parent, child) {
                var actualParent = getAncestor(child);
                if (actualParent) {
                    if (actualParent === parent) {
                        return true;
                    }
                    return false;
                }
                if (child === parent) {
                    return false;
                }
                if (getTop(child) === child) {
                    return false;
                }
                for (var _iterator7 = getFrames(parent), _isArray7 = Array.isArray(_iterator7), _i9 = 0, _iterator7 = _isArray7 ? _iterator7 : _iterator7[Symbol.iterator](); ;) {
                    var _ref7;
                    if (_isArray7) {
                        if (_i9 >= _iterator7.length) break;
                        _ref7 = _iterator7[_i9++];
                    } else {
                        _i9 = _iterator7.next();
                        if (_i9.done) break;
                        _ref7 = _i9.value;
                    }
                    var frame = _ref7;
                    if (frame === child) {
                        return true;
                    }
                }
                return false;
            }
            function isPopup() {
                return Boolean(getOpener(window));
            }
            function isIframe() {
                return Boolean(getParent(window));
            }
            function isFullpage() {
                return Boolean(!isIframe() && !isPopup());
            }
            function anyMatch(collection1, collection2) {
                for (var _iterator8 = collection1, _isArray8 = Array.isArray(_iterator8), _i10 = 0, _iterator8 = _isArray8 ? _iterator8 : _iterator8[Symbol.iterator](); ;) {
                    var _ref8;
                    if (_isArray8) {
                        if (_i10 >= _iterator8.length) break;
                        _ref8 = _iterator8[_i10++];
                    } else {
                        _i10 = _iterator8.next();
                        if (_i10.done) break;
                        _ref8 = _i10.value;
                    }
                    var item1 = _ref8;
                    for (var _iterator9 = collection2, _isArray9 = Array.isArray(_iterator9), _i11 = 0, _iterator9 = _isArray9 ? _iterator9 : _iterator9[Symbol.iterator](); ;) {
                        var _ref9;
                        if (_isArray9) {
                            if (_i11 >= _iterator9.length) break;
                            _ref9 = _iterator9[_i11++];
                        } else {
                            _i11 = _iterator9.next();
                            if (_i11.done) break;
                            _ref9 = _i11.value;
                        }
                        var item2 = _ref9;
                        if (item1 === item2) {
                            return true;
                        }
                    }
                }
                return false;
            }
            function getDistanceFromTop() {
                var win = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;
                var distance = 0;
                var parent = win;
                while (parent) {
                    parent = getParent(parent);
                    if (parent) {
                        distance += 1;
                    }
                }
                return distance;
            }
            function getNthParent(win) {
                var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
                var parent = win;
                for (var i = 0; i < n; i++) {
                    if (!parent) {
                        return;
                    }
                    parent = getParent(parent);
                }
                return parent;
            }
            function getNthParentFromTop(win) {
                var n = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
                return getNthParent(win, getDistanceFromTop(win) - n);
            }
            function isSameTopWindow(win1, win2) {
                var top1 = getTop(win1) || win1;
                var top2 = getTop(win2) || win2;
                try {
                    if (top1 && top2) {
                        if (top1 === top2) {
                            return true;
                        }
                        return false;
                    }
                } catch (err) {}
                var allFrames1 = getAllFramesInWindow(win1);
                var allFrames2 = getAllFramesInWindow(win2);
                if (anyMatch(allFrames1, allFrames2)) {
                    return true;
                }
                var opener1 = getOpener(top1);
                var opener2 = getOpener(top2);
                if (opener1 && anyMatch(getAllFramesInWindow(opener1), allFrames2)) {
                    return false;
                }
                if (opener2 && anyMatch(getAllFramesInWindow(opener2), allFrames1)) {
                    return false;
                }
                return false;
            }
            function matchDomain(pattern, origin) {
                if (typeof pattern === "string") {
                    if (typeof origin === "string") {
                        return pattern === CONSTANTS.WILDCARD || origin === pattern;
                    }
                    if ((0, _util.isRegex)(origin)) {
                        return false;
                    }
                    if (Array.isArray(origin)) {
                        return false;
                    }
                }
                if ((0, _util.isRegex)(pattern)) {
                    if ((0, _util.isRegex)(origin)) {
                        return pattern.toString() === origin.toString();
                    }
                    if (Array.isArray(origin)) {
                        return false;
                    }
                    return Boolean(origin.match(pattern));
                }
                if (Array.isArray(pattern)) {
                    if (Array.isArray(origin)) {
                        return JSON.stringify(pattern) === JSON.stringify(origin);
                    }
                    if ((0, _util.isRegex)(origin)) {
                        return false;
                    }
                    return pattern.some(function(subpattern) {
                        return matchDomain(subpattern, origin);
                    });
                }
                return false;
            }
            function getDomainFromUrl(url) {
                var domain = void 0;
                if (url.match(/^(https?|mock|file):\/\//)) {
                    domain = url;
                } else {
                    return getDomain();
                }
                domain = domain.split("/").slice(0, 3).join("/");
                return domain;
            }
            function onCloseWindow(win, callback) {
                var delay = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1e3;
                var maxtime = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Infinity;
                var timeout = void 0;
                var check = function check() {
                    if (isWindowClosed(win)) {
                        if (timeout) {
                            clearTimeout(timeout);
                        }
                        return callback();
                    }
                    if (maxtime <= 0) {
                        clearTimeout(timeout);
                    } else {
                        maxtime -= delay;
                        timeout = setTimeout(check, delay);
                    }
                };
                check();
                return {
                    cancel: function cancel() {
                        if (timeout) {
                            clearTimeout(timeout);
                        }
                    }
                };
            }
            function isWindow(obj) {
                try {
                    if (obj === window) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    if (Object.prototype.toString.call(obj) === "[object Window]") {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    if (window.Window && obj instanceof window.Window) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    if (obj && obj.self === obj) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    if (obj && obj.parent === obj) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    if (obj && obj.top === obj) {
                        return true;
                    }
                } catch (err) {
                    if (err && err.message === IE_WIN_ACCESS_ERROR) {
                        return true;
                    }
                }
                try {
                    (0, _util.noop)(obj === obj);
                } catch (err) {
                    return true;
                }
                try {
                    (0, _util.noop)(obj && obj.__cross_domain_utils_window_check__);
                } catch (err) {
                    return true;
                }
                return false;
            }
        },
        "./node_modules/cross-domain-utils/src/util.js": function(module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.isRegex = isRegex;
            exports.noop = noop;
            function isRegex(item) {
                return Object.prototype.toString.call(item) === "[object RegExp]";
            }
            function noop() {}
        },
        "./src/native.js": function(module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.hasNativeWeakMap = hasNativeWeakMap;
            function hasNativeWeakMap() {
                if (!window.WeakMap) {
                    return false;
                }
                if (!window.Object.freeze) {
                    return false;
                }
                try {
                    var testWeakMap = new window.WeakMap();
                    var testKey = {};
                    var testValue = "__testvalue__";
                    window.Object.freeze(testKey);
                    testWeakMap.set(testKey, testValue);
                    if (testWeakMap.get(testKey) === testValue) {
                        return true;
                    }
                    return false;
                } catch (err) {
                    return false;
                }
            }
        },
        "./src/util.js": function(module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: true
            });
            exports.safeIndexOf = safeIndexOf;
            exports.noop = noop;
            function safeIndexOf(collection, item) {
                for (var i = 0; i < collection.length; i++) {
                    try {
                        if (collection[i] === item) {
                            return i;
                        }
                    } catch (err) {}
                }
                return -1;
            }
            function noop() {}
        }
    });
});


//# sourceMappingURL=cross-domain-safe-weakmap.js.map