'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _cosmiconfig = require('cosmiconfig');

var _cosmiconfig2 = _interopRequireDefault(_cosmiconfig);

var _isResolvable = require('is-resolvable');

var _isResolvable2 = _interopRequireDefault(_isResolvable);

var _cssnanoPresetDefault = require('cssnano-preset-default');

var _cssnanoPresetDefault2 = _interopRequireDefault(_cssnanoPresetDefault);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var cssnano = 'cssnano';

var explorer = (0, _cosmiconfig2.default)(cssnano, {
    rc: false,
    argv: false
});

function initializePlugin(plugin, css, result) {
    if (Array.isArray(plugin)) {
        var _plugin = _slicedToArray(plugin, 2),
            processor = _plugin[0],
            opts = _plugin[1];

        if (typeof opts === 'undefined' || typeof opts === 'object' && !opts.exclude) {
            return Promise.resolve(processor(opts)(css, result));
        }
    } else {
        return Promise.resolve(plugin()(css, result));
    }
    // Handle excluded plugins
    return Promise.resolve();
}

function fromFile(css, result) {
    var filePath = css.source && css.source.input && css.source.input.file || process.cwd();
    result.messages.push({
        type: 'debug',
        plugin: cssnano,
        message: `Using config relative to "${filePath}"`
    });
    return filePath;
}

/*
 * preset can be one of four possibilities:
 * preset = 'default'
 * preset = ['default', {}]
 * preset = function <- to be invoked
 * preset = {plugins: []} <- already invoked function
 */

function resolvePreset(preset) {
    var fn = void 0,
        options = void 0;
    if (Array.isArray(preset)) {
        fn = preset[0];
        options = preset[1];
    } else {
        fn = preset;
        options = {};
    }
    // For JS setups where we invoked the preset already
    if (preset.plugins) {
        return Promise.resolve(preset.plugins);
    }
    // Provide an alias for the default preset, as it is built-in.
    if (fn === 'default') {
        return Promise.resolve((0, _cssnanoPresetDefault2.default)(options).plugins);
    }
    // For non-JS setups; we'll need to invoke the preset ourselves.
    if (typeof fn === 'function') {
        return Promise.resolve(fn(options).plugins);
    }
    // Try loading a preset from node_modules
    if ((0, _isResolvable2.default)(fn)) {
        return Promise.resolve(require(fn)(options).plugins);
    }
    var sugar = `cssnano-preset-${fn}`;
    // Try loading a preset from node_modules (sugar)
    if ((0, _isResolvable2.default)(sugar)) {
        return Promise.resolve(require(sugar)(options).plugins);
    }
    // If all else fails, we probably have a typo in the config somewhere
    throw new Error(`Cannot load preset "${fn}". Please check your configuration for errors and try again.`);
}

/*
 * cssnano will look for configuration firstly as options passed
 * directly to it, and failing this it will use cosmiconfig to
 * load an external file.
 */

function resolveConfig(css, result, options) {
    if (options.preset) {
        return resolvePreset(options.preset);
    }
    return explorer.load(fromFile(css, result)).then(function (config) {
        if (config === null) {
            return resolvePreset('default');
        }
        return resolvePreset(config.config.preset || config.config);
    });
}

exports.default = _postcss2.default.plugin(cssnano, function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    return function (css, result) {
        return resolveConfig(css, result, options).then(function (plugins) {
            return plugins.reduce(function (promise, plugin) {
                return promise.then(initializePlugin.bind(null, plugin, css, result));
            }, Promise.resolve());
        });
    };
});
module.exports = exports['default'];