"use strict";

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.getLines = getLines;
exports.getLineInfo = getLineInfo;
var lineBreakRegex = /\r\n|\r|\n/;
var lineBreakRegexGlobal = /\r\n|\r|\n/g;

function getLines(input) {
    return input.split(lineBreakRegex);
}

function getLineInfo(code) {
    var lines = [];
    lineBreakRegexGlobal.lastIndex = 0;
    var lastOffset = 0;
    var match = void 0;
    while ((match = lineBreakRegexGlobal.exec(code)) !== null) {
        lines.push({
            offset: lastOffset,
            text: code.substring(lastOffset, match.index),
            lineBreak: match[0]
        });
        lastOffset = match.index + match[0].length;
    }
    lines.push({ offset: lastOffset, text: code.substr(lastOffset), lineBreak: null });
    return lines;
}
//# sourceMappingURL=lines.js.map