// Generated by CoffeeScript 2.5.1
// # CSV Generator Sync

// Provides a synchronous alternative to the CSV generator.

// ## Usage 

// `const csv = generate(options)`  

// ## Source Code
var generate;

generate = require('.');

module.exports = function(options) {
  var chunks, generator, work;
  if (typeof options === 'string' && /\d+/.test(options)) {
    options = parseInt(options);
  }
  if (Number.isInteger(options)) {
    options = {
      length: options
    };
  }
  if (!Number.isInteger(options != null ? options.length : void 0)) {
    throw Error('Invalid Argument: length is not defined');
  }
  chunks = [];
  work = true;
  // See https://nodejs.org/api/stream.html#stream_new_stream_readable_options
  options.highWaterMark = options.objectMode ? 16 : 16384;
  generator = new generate.Generator(options);
  generator.push = function(chunk) {
    if (chunk === null) {
      return work = false;
    }
    if (options.objectMode) {
      return chunks.push(chunk);
    } else {
      return chunks.push(chunk);
    }
  };
  while (work) {
    generator._read(options.highWaterMark);
  }
  if (!options.objectMode) {
    chunks = chunks.join('');
  }
  return chunks;
};
