// Generated by CoffeeScript 2.4.1
// # CSV Stringifier

// Please look at the [project documentation](https://csv.js.org/stringify/) for additional
// information.
var Stringifier, castPath, charCodeOfDot, get, getTag, isKey, isObject, isSymbol, reEscapeChar, reIsDeepProp, reIsPlainProp, rePropName, stream, stringToPath, toKey, underscore, util;

stream = require('stream');

util = require('util');

// ## Usage

// This module export a function as its main entry point and return a transform
// stream.

// Refers to the [official prject documentation](http://csv.adaltas.com/stringify/)
// on how to call this function.
module.exports = function() {
  var callback, chunks, data, options, stringifier;
  if (arguments.length === 3) {
    data = arguments[0];
    options = arguments[1];
    callback = arguments[2];
  } else if (arguments.length === 2) {
    if (Array.isArray(arguments[0])) {
      data = arguments[0];
    } else {
      options = arguments[0];
    }
    if (typeof arguments[1] === 'function') {
      callback = arguments[1];
    } else {
      options = arguments[1];
    }
  } else if (arguments.length === 1) {
    if (typeof arguments[0] === 'function') {
      callback = arguments[0];
    } else if (Array.isArray(arguments[0])) {
      data = arguments[0];
    } else {
      options = arguments[0];
    }
  }
  if (options == null) {
    options = {};
  }
  stringifier = new Stringifier(options);
  if (data) {
    process.nextTick(function() {
      var d, j, len;
      for (j = 0, len = data.length; j < len; j++) {
        d = data[j];
        stringifier.write(d);
      }
      return stringifier.end();
    });
  }
  if (callback) {
    chunks = [];
    stringifier.on('readable', function() {
      var chunk, results;
      results = [];
      while (chunk = stringifier.read()) {
        results.push(chunks.push(chunk));
      }
      return results;
    });
    stringifier.on('error', function(err) {
      return callback(err);
    });
    stringifier.on('end', function() {
      return callback(null, chunks.join(''));
    });
  }
  return stringifier;
};

// You can also use *util.promisify* native function (Node.js 8+) in order to wrap callbacks into promises for more convenient use when source is a readable stream and you are OK with storing entire result set in memory:

// ```
// const { promisify } = require('util');
// const csv = require('csv');
// const stringifyAsync = promisify(csv.stringify);

// //returns promise
// function generateCsv(sourceData) {
//     return stringifyAsync(sourceData);
// }
// ```

// ## `Stringifier([options])`

// Options are documented [here](http://csv.adaltas.com/stringify/).
Stringifier = class Stringifier extends stream.Transform {
  constructor(opts = {}) {
    var base, base1, base2, base3, base4, isRegExp, isString, j, k, len, options, quoted_match, ref, v;
    super({...{
        writableObjectMode: true
      }, ...options});
    options = {};
    for (k in opts) {
      v = opts[k];
      // Immutable options and camelcase conversion
      options[underscore(k)] = v;
    }
    // Normalize option `delimiter`
    if (options.delimiter === null || options.delimiter === void 0) {
      options.delimiter = ',';
    } else {
      if (Buffer.isBuffer(options.delimiter)) {
        options.delimiter = options.delimiter.toString();
      } else if (typeof options.delimiter !== 'string') {
        throw new Error(`Invalid Option: delimiter must be a buffer or a string, got ${JSON.stringify(options.delimiter)}`);
      }
    }
    // Normalize option `quote`
    if (options.quote === null || options.quote === void 0) {
      options.quote = '"';
    } else {
      if (options.quote === true) {
        options.quote = '"';
      } else if (options.quote === false) {
        options.quote = '';
      } else if (Buffer.isBuffer(options.quote)) {
        options.quote = options.quote.toString();
      } else if (typeof options.quote !== 'string') {
        throw new Error(`Invalid Option: quote must be a boolean, a buffer or a string, got ${JSON.stringify(options.quote)}`);
      }
    }
    // Normalize option `quoted`
    if (options.quoted == null) {
      options.quoted = false;
    }
    if (options.quoted_empty == null) {
      options.quoted_empty = void 0;
    }
    if (options.quoted_string == null) {
      options.quoted_string = false;
    }
    if (options.eof == null) {
      options.eof = true;
    }
    // Normalize option `escape`
    if (options.escape === null || options.escape === void 0) {
      options.escape = '"';
    } else {
      if (Buffer.isBuffer(options.escape)) {
        options.escape = options.escape.toString();
      }
      if (typeof options.escape !== 'string') {
        throw new Error(`Invalid Option: escape must be a buffer or a string, got ${JSON.stringify(options.escape)}`);
      } else if (options.escape.length > 1) {
        throw new Error(`Invalid Option: escape must be one character, got ${options.escape.length} characters`);
      }
    }
    if (options.header == null) {
      options.header = false;
    }
    // Normalize the columns option
    options.columns = this.normalize_columns(options.columns);
    if (options.cast == null) {
      options.cast = {};
    }
    // Normalize option `quoted_match`
    if (options.quoted_match === void 0 || options.quoted_match === null || options.quoted_match === false) {
      options.quoted_match = null;
    } else if (!Array.isArray(options.quoted_match)) {
      options.quoted_match = [options.quoted_match];
    }
    if (options.quoted_match) {
      ref = options.quoted_match;
      for (j = 0, len = ref.length; j < len; j++) {
        quoted_match = ref[j];
        isString = typeof quoted_match === 'string';
        isRegExp = quoted_match instanceof RegExp;
        if (!isString && !isRegExp) {
          throw new Error(`Invalid Option: quoted_match must be a string or a regex, got ${JSON.stringify(quoted_match)}`);
        }
      }
    }
    if (options.cast.bool) {
      // Backward compatibility
      options.cast.boolean = options.cast.bool;
    }
    // Custom cast
    if ((base = options.cast).boolean == null) {
      base.boolean = function(value) {
        // Cast boolean to string by default
        if (value) {
          return '1';
        } else {
          return '';
        }
      };
    }
    if ((base1 = options.cast).date == null) {
      base1.date = function(value) {
        // Cast date to timestamp string by default
        return '' + value.getTime();
      };
    }
    if ((base2 = options.cast).number == null) {
      base2.number = function(value) {
        // Cast number to string using native casting by default
        return '' + value;
      };
    }
    if ((base3 = options.cast).object == null) {
      base3.object = function(value) {
        // Stringify object as JSON by default
        return JSON.stringify(value);
      };
    }
    if ((base4 = options.cast).string == null) {
      base4.string = function(value) {
        return value;
      };
    }
    // Normalize option `record_delimiter`
    if (options.record_delimiter === void 0 || options.record_delimiter === null) {
      if (options.record_delimiter == null) {
        options.record_delimiter = '\n';
      }
    } else {
      if (Buffer.isBuffer(options.record_delimiter)) {
        options.record_delimiter = options.record_delimiter.toString();
      } else if (typeof options.record_delimiter !== 'string') {
        throw new Error(`Invalid Option: record_delimiter must be a buffer or a string, got ${JSON.stringify(options.record_delimiter)}`);
      }
      switch (options.record_delimiter) {
        case 'auto':
          options.record_delimiter = null;
          break;
        case 'unix':
          options.record_delimiter = "\n";
          break;
        case 'mac':
          options.record_delimiter = "\r";
          break;
        case 'windows':
          options.record_delimiter = "\r\n";
          break;
        case 'ascii':
          options.record_delimiter = "\u001e";
          break;
        case 'unicode':
          options.record_delimiter = "\u2028";
      }
    }
    // Expose options
    this.options = options;
    // Internal state
    this.state = {
      stop: false
    };
    // Information
    this.info = {
      records: 0
    };
    this;
  }

  // ## `Stringifier.prototype._transform(chunk, encoding, callback)`

  // Implementation of the [transform._transform function](https://nodejs.org/api/stream.html#stream_transform_transform_chunk_encoding_callback).
  _transform(chunk, encoding, callback) {
    var base, e;
    if (this.state.stop === true) {
      return;
    }
    // Chunk validation
    if (!(Array.isArray(chunk) || typeof chunk === 'object')) {
      this.state.stop = true;
      return callback(Error(`Invalid Record: expect an array or an object, got ${JSON.stringify(chunk)}`));
    }
    // Detect columns from the first record
    if (this.info.records === 0) {
      if (Array.isArray(chunk)) {
        if (this.options.header === true && !this.options.columns) {
          this.state.stop = true;
          return callback(Error('Undiscoverable Columns: header option requires column option or object records'));
        }
      } else {
        if ((base = this.options).columns == null) {
          base.columns = this.normalize_columns(Object.keys(chunk));
        }
      }
    }
    if (this.info.records === 0) {
      // Emit the header
      this.headers();
    }
    try {
      // Emit and stringify the record if an object or an array
      this.emit('record', chunk, this.info.records);
    } catch (error) {
      e = error;
      this.state.stop = true;
      return this.emit('error', e);
    }
    // Convert the record into a string
    if (this.options.eof) {
      chunk = this.stringify(chunk);
      if (chunk == null) {
        return;
      }
      chunk = chunk + this.options.record_delimiter;
    } else {
      chunk = this.stringify(chunk);
      if (chunk == null) {
        return;
      }
      if (this.options.header || this.info.records) {
        chunk = this.options.record_delimiter + chunk;
      }
    }
    // Emit the csv
    this.info.records++;
    this.push(chunk);
    return callback();
  }

  // ## `Stringifier.prototype._flush(callback)`

  // Implementation of the [transform._flush function](https://nodejs.org/api/stream.html#stream_transform_flush_callback).
  _flush(callback) {
    if (this.info.records === 0) {
      this.headers();
    }
    return callback();
  }

  // ## `Stringifier.prototype.stringify(line)`

  // Convert a line to a string. Line may be an object, an array or a string.
  stringify(chunk) {
    var column, columns, containsEscape, containsQuote, containsRowDelimiter, containsdelimiter, csvrecord, delimiter, err, escape, field, header, i, j, l, len, m, options, quote, quoted, quotedMatch, quotedString, quoted_empty, quoted_match, quoted_string, record, record_delimiter, ref, ref1, regexp, shouldQuote, value;
    if (typeof chunk !== 'object') {
      return chunk;
    }
    ({columns, header} = this.options);
    record = [];
    // Record is an array
    if (Array.isArray(chunk)) {
      if (columns) {
        // We are getting an array but the user has specified output columns. In
        // this case, we respect the columns indexes
        chunk.splice(columns.length);
      }
// Cast record elements
      for (i = j = 0, len = chunk.length; j < len; i = ++j) {
        field = chunk[i];
        [err, value] = this.__cast(field, {
          index: i,
          column: i,
          records: this.info.records,
          header: header && this.info.records === 0
        });
        if (err) {
          this.emit('error', err);
          return;
        }
        record[i] = [value, field];
      }
    } else {
      // Record is a literal object
      if (columns) {
        for (i = l = 0, ref = columns.length; (0 <= ref ? l < ref : l > ref); i = 0 <= ref ? ++l : --l) {
          field = get(chunk, columns[i].key);
          [err, value] = this.__cast(field, {
            index: i,
            column: columns[i].key,
            records: this.info.records,
            header: header && this.info.records === 0
          });
          if (err) {
            this.emit('error', err);
            return;
          }
          record[i] = [value, field];
        }
      } else {
        for (column in chunk) {
          field = chunk[column];
          [err, value] = this.__cast(field, {
            index: i,
            column: columns[i].key,
            records: this.info.records,
            header: header && this.info.records === 0
          });
          if (err) {
            this.emit('error', err);
            return;
          }
          record.push([value, field]);
        }
      }
    }
    csvrecord = '';
    for (i = m = 0, ref1 = record.length; (0 <= ref1 ? m < ref1 : m > ref1); i = 0 <= ref1 ? ++m : --m) {
      [value, field] = record[i];
      if (typeof value === 'string') {
        options = this.options;
      } else if (isObject(value)) {
        ({value, ...options} = value);
        if (!(typeof value === 'string' || value === void 0 || value === null)) {
          this.emit('error', Error(`Invalid Casting Value: returned value must return a string, null or undefined, got ${JSON.stringify(value)}`));
          return;
        }
        options = {...this.options, ...options};
      } else if (value === void 0 || value === null) {
        options = this.options;
      } else {
        this.emit('error', Error(`Invalid Casting Value: returned value must return a string, an object, null or undefined, got ${JSON.stringify(value)}`));
        return;
      }
      ({delimiter, escape, quote, quoted, quoted_empty, quoted_string, quoted_match, record_delimiter} = options);
      if (value) {
        if (typeof value !== 'string') {
          this.emit('error', Error(`Formatter must return a string, null or undefined, got ${JSON.stringify(value)}`));
          return null;
        }
        containsdelimiter = delimiter.length && value.indexOf(delimiter) >= 0;
        containsQuote = (quote !== '') && value.indexOf(quote) >= 0;
        containsEscape = value.indexOf(escape) >= 0 && (escape !== quote);
        containsRowDelimiter = value.indexOf(record_delimiter) >= 0;
        quotedString = quoted_string && typeof field === 'string';
        quotedMatch = quoted_match && typeof field === 'string' && quoted_match.filter(function(quoted_match) {
          if (typeof quoted_match === 'string') {
            return value.indexOf(quoted_match) !== -1;
          } else {
            return quoted_match.test(value);
          }
        });
        quotedMatch = quotedMatch && quotedMatch.length > 0;
        shouldQuote = containsQuote || containsdelimiter || containsRowDelimiter || quoted || quotedString || quotedMatch;
        if (shouldQuote && containsEscape) {
          regexp = escape === '\\' ? new RegExp(escape + escape, 'g') : new RegExp(escape, 'g');
          value = value.replace(regexp, escape + escape);
        }
        if (containsQuote) {
          regexp = new RegExp(quote, 'g');
          value = value.replace(regexp, escape + quote);
        }
        if (shouldQuote) {
          value = quote + value + quote;
        }
        csvrecord += value;
      } else if (quoted_empty || ((quoted_empty == null) && field === '' && quoted_string)) {
        csvrecord += quote + quote;
      }
      if (i !== record.length - 1) {
        csvrecord += delimiter;
      }
    }
    return csvrecord;
  }

  // ## `Stringifier.prototype.headers`

  // Print the header line if the option "header" is "true".
  headers() {
    var headers;
    if (!this.options.header) {
      return;
    }
    if (!this.options.columns) {
      return;
    }
    headers = this.options.columns.map(function(column) {
      return column.header;
    });
    if (this.options.eof) {
      headers = this.stringify(headers) + this.options.record_delimiter;
    } else {
      headers = this.stringify(headers);
    }
    return this.push(headers);
  }

  __cast(value, context) {
    var err, type;
    type = typeof value;
    try {
      if (type === 'string') {
        // Fine for 99% of the cases
        return [void 0, this.options.cast.string(value, context)];
      } else if (type === 'number') {
        return [void 0, this.options.cast.number(value, context)];
      } else if (type === 'boolean') {
        return [void 0, this.options.cast.boolean(value, context)];
      } else if (value instanceof Date) {
        return [void 0, this.options.cast.date(value, context)];
      } else if (type === 'object' && value !== null) {
        return [void 0, this.options.cast.object(value, context)];
      } else {
        return [void 0, value, value];
      }
    } catch (error) {
      err = error;
      return [err];
    }
  }

  // ## `Stringifier.prototype.normalize_columns`
  normalize_columns(columns) {
    var column, k, v;
    if (columns == null) {
      return null;
    }
    if (columns != null) {
      if (typeof columns !== 'object') {
        throw Error('Invalid option "columns": expect an array or an object');
      }
      if (!Array.isArray(columns)) {
        columns = (function() {
          var results;
          results = [];
          for (k in columns) {
            v = columns[k];
            results.push({
              key: k,
              header: v
            });
          }
          return results;
        })();
      } else {
        columns = (function() {
          var j, len, results;
          results = [];
          for (j = 0, len = columns.length; j < len; j++) {
            column = columns[j];
            if (typeof column === 'string') {
              results.push({
                key: column,
                header: column
              });
            } else if (typeof column === 'object' && (column != null) && !Array.isArray(column)) {
              if (!column.key) {
                throw Error('Invalid column definition: property "key" is required');
              }
              if (column.header == null) {
                column.header = column.key;
              }
              results.push(column);
            } else {
              throw Error('Invalid column definition: expect a string or an object');
            }
          }
          return results;
        })();
      }
    }
    return columns;
  }

};

module.exports.Stringifier = Stringifier;

isObject = function(obj) {
  return typeof obj === 'object' && obj !== null && !Array.isArray(obj);
};

underscore = function(str) {
  return str.replace(/([A-Z])/g, function(_, match, index) {
    return '_' + match.toLowerCase();
  });
};

// ## Lodash implementation of `get`
charCodeOfDot = '.'.charCodeAt(0);

reEscapeChar = /\\(\\)?/g;

// Match anything that isn't a dot or bracket.
// Or match property names within brackets.
// Match a non-string expression.
// Or match strings (supports escaping characters).
// Or match "" as the space between consecutive dots or empty brackets.
rePropName = RegExp('[^.[\\]]+' + '|' + '\\[(?:' + '([^"\'][^[]*)' + '|' + '(["\'])((?:(?!\\2)[^\\\\]|\\\\.)*?)\\2' + ')\\]' + '|' + '(?=(?:\\.|\\[\\])(?:\\.|\\[\\]|$))', 'g');

reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/;

reIsPlainProp = /^\w*$/;

getTag = function(value) {
  if (value != null) {
    if (value === void 0) {
      '[object Undefined]';
    } else {
      '[object Null]';
    }
  }
  return Object.prototype.toString.call(value);
};

isKey = function(value, object) {
  var type;
  if (Array.isArray(value)) {
    return false;
  }
  type = typeof value;
  if (type === 'number' || type === 'symbol' || type === 'boolean' || (value == null) || isSymbol(value)) {
    return true;
  }
  return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || ((object != null) && value in Object(object));
};

isSymbol = function(value) {
  var type;
  type = typeof value;
  return type === 'symbol' || (type === 'object' && (value != null) && getTag(value) === '[object Symbol]');
};

stringToPath = function(string) {
  var result;
  result = [];
  if (string.charCodeAt(0) === charCodeOfDot) {
    result.push('');
  }
  string.replace(rePropName, function(match, expression, quote, subString) {
    var key;
    key = match;
    if (quote) {
      key = subString.replace(reEscapeChar, '$1');
    } else if (expression) {
      key = expression.trim();
    }
    return result.push(key);
  });
  return result;
};

castPath = function(value, object) {
  if (Array.isArray(value)) {
    return value;
  } else {
    if (isKey(value, object)) {
      return [value];
    } else {
      return stringToPath(value);
    }
  }
};

toKey = function(value) {
  var ref, result;
  if (typeof value === 'string' || isSymbol(value)) {
    return value;
  }
  result = `${value}`;
  return (ref = result === '0' && (1 / value) === -INFINITY) != null ? ref : {
    '-0': result
  };
};

get = function(object, path) {
  var index, length;
  path = Array.isArray(path) ? path : castPath(path, object);
  index = 0;
  length = path.length;
  while ((object != null) && index < length) {
    object = object[toKey(path[index++])];
  }
  if (index && index === length) {
    return object;
  } else {
    return void 0;
  }
};
