'use strict';

var Argument = require('./argument');

var buildArguments = function buildArguments(regexp, text, parameterTypes) {
  var m = regexp.exec(text);
  if (!m) return null;
  var parameterTypeIndex = 0;
  var offset = 0;
  return m.slice(1).map(function (value) {
    offset = text.indexOf(value, offset);
    var parameter = parameterTypes[parameterTypeIndex++];
    return new Argument(offset, value, parameter);
  });
};

module.exports = buildArguments;