'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ParameterTypeMatcher = require('./parameter_type_matcher');
var GeneratedExpression = require('./generated_expression');

var CucumberExpressionGenerator = function () {
  function CucumberExpressionGenerator(parameterTypeRegistry) {
    _classCallCheck(this, CucumberExpressionGenerator);

    this._parameterTypeRegistry = parameterTypeRegistry;
  }

  _createClass(CucumberExpressionGenerator, [{
    key: 'generateExpression',
    value: function generateExpression(text) {
      var parameterNames = [];
      var parameterTypeMatchers = this._createParameterTypeMatchers(text);
      var parameterTypes = [];
      var usageByTypeName = {};

      var expression = "";
      var pos = 0;

      while (true) {
        // eslint-disable-line no-constant-condition
        var matchingParameterTypeMatchers = [];
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = parameterTypeMatchers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var parameterTypeMatcher = _step.value;

            var advancedParameterTypeMatcher = parameterTypeMatcher.advanceTo(pos);
            if (advancedParameterTypeMatcher.find) {
              matchingParameterTypeMatchers.push(advancedParameterTypeMatcher);
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        if (matchingParameterTypeMatchers.length > 0) {
          matchingParameterTypeMatchers = matchingParameterTypeMatchers.sort(ParameterTypeMatcher.compare);
          var bestParameterTypeMatcher = matchingParameterTypeMatchers[0];
          var parameter = bestParameterTypeMatcher.parameterType;
          parameterTypes.push(parameter);

          var parameterName = this._getParameterName(parameter.name, usageByTypeName);
          parameterNames.push(parameterName);

          expression += text.slice(pos, bestParameterTypeMatcher.start);
          expression += '{' + parameter.name + '}';

          pos = bestParameterTypeMatcher.start + bestParameterTypeMatcher.group.length;
        } else {
          break;
        }

        if (pos >= text.length) {
          break;
        }
      }

      expression += text.slice(pos);
      return new GeneratedExpression(expression, parameterNames, parameterTypes);
    }
  }, {
    key: '_getParameterName',
    value: function _getParameterName(typeName, usageByTypeName) {
      var count = usageByTypeName[typeName];
      count = count ? count + 1 : 1;
      usageByTypeName[typeName] = count;

      return count == 1 ? typeName : '' + typeName + count;
    }
  }, {
    key: '_createParameterTypeMatchers',
    value: function _createParameterTypeMatchers(text) {
      var parameterMatchers = [];
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this._parameterTypeRegistry.parameterTypes[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var parameter = _step2.value;

          parameterMatchers = parameterMatchers.concat(this._createParameterTypeMatchers2(parameter, text));
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return parameterMatchers;
    }
  }, {
    key: '_createParameterTypeMatchers2',
    value: function _createParameterTypeMatchers2(parameter, text) {
      var result = [];
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = parameter.regexps[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var regexp = _step3.value;

          result.push(new ParameterTypeMatcher(parameter, regexp, text));
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      return result;
    }
  }]);

  return CucumberExpressionGenerator;
}();

module.exports = CucumberExpressionGenerator;