'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Parameter = require('./parameter_type');

var ParameterTypeRegistry = function () {
  function ParameterTypeRegistry() {
    _classCallCheck(this, ParameterTypeRegistry);

    this._parameterTypesByTypeName = new Map();
    this._parameterTypesByRegexp = new Map();
    this._parameterTypesByConstructorName = new Map();

    var INTEGER_REGEXPS = [/-?\d+/, /\d+/];
    var FLOAT_REGEXP = /-?\d*\.?\d+/;

    this._definePredefinedParameterType(new Parameter('int', Number, INTEGER_REGEXPS, parseInt));
    this._definePredefinedParameterType(new Parameter('float', Number, FLOAT_REGEXP, parseFloat));
  }

  _createClass(ParameterTypeRegistry, [{
    key: 'lookupByType',
    value: function lookupByType(type) {
      if (typeof type === 'function') {
        return this.lookupByFunction(type);
      } else if (typeof type === 'string') {
        return this.lookupByTypeName(type);
      } else {
        throw new Error('Type must be string or function, but was ' + type + ' of type ' + (typeof type === 'undefined' ? 'undefined' : _typeof(type)));
      }
    }
  }, {
    key: 'lookupByFunction',
    value: function lookupByFunction(fn) {
      if (fn.name) {
        var looksLikeCtor = looksLikeConstructor(fn);

        var parameter = void 0;
        if (looksLikeCtor) {
          parameter = this._parameterTypesByConstructorName.get(fn.name);
        }
        if (!parameter) {
          var factory = function factory(s) {
            if (looksLikeCtor) {
              return new fn(s);
            } else {
              return fn(s);
            }
          };
          return this.createAnonymousLookup(factory);
        } else {
          return parameter;
        }
      } else {
        return this.createAnonymousLookup(fn);
      }
    }
  }, {
    key: 'lookupByTypeName',
    value: function lookupByTypeName(typeName) {
      return this._parameterTypesByTypeName.get(typeName);
    }
  }, {
    key: 'lookupByRegexp',
    value: function lookupByRegexp(regexp) {
      return this._parameterTypesByRegexp.get(regexp);
    }
  }, {
    key: 'createAnonymousLookup',
    value: function createAnonymousLookup(fn) {
      return new Parameter(null, null, [".+"], fn);
    }
  }, {
    key: 'defineParameterType',
    value: function defineParameterType(parameterType) {
      this._defineParameterType(parameterType, true);
    }
  }, {
    key: '_definePredefinedParameterType',
    value: function _definePredefinedParameterType(parameterType) {
      this._defineParameterType(parameterType, false);
    }
  }, {
    key: '_defineParameterType',
    value: function _defineParameterType(parameterType, checkConflicts) {
      if (looksLikeConstructor(parameterType.constructorFunction)) {
        set(this._parameterTypesByConstructorName, parameterType.constructorFunction.name, parameterType, 'constructor', checkConflicts);
      }
      set(this._parameterTypesByTypeName, parameterType.name, parameterType, 'type name', checkConflicts);

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = parameterType.regexps[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var regexp = _step.value;

          set(this._parameterTypesByRegexp, regexp, parameterType, 'regexp', checkConflicts);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'parameterTypes',
    get: function get() {
      return this._parameterTypesByTypeName.values();
    }
  }]);

  return ParameterTypeRegistry;
}();

function set(map, key, value, prop, checkConflicts) {
  if (checkConflicts && map.has(key)) throw new Error('There is already a parameter with ' + prop + ' ' + key);
  map.set(key, value);
}

function looksLikeConstructor(fn) {
  if (typeof fn !== 'function') return false;
  if (!fn.name) return false;
  var prefix = fn.name[0];
  return prefix.toUpperCase() === prefix;
}

module.exports = ParameterTypeRegistry;