'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var buildArguments = require('./build_arguments');

var RegularExpression = function () {
  function RegularExpression(regexp, types, parameterTypeRegistry) {
    _classCallCheck(this, RegularExpression);

    this._regexp = regexp;
    this._parameterTypes = [];

    var CAPTURE_GROUP_PATTERN = /\(([^(]+)\)/g;

    var typeIndex = 0;
    var match = void 0;
    while ((match = CAPTURE_GROUP_PATTERN.exec(regexp.source)) !== null) {
      var captureGroupPattern = match[1];
      var type = types.length <= typeIndex ? null : types[typeIndex++];

      var parameterType = void 0;
      if (type) {
        parameterType = parameterTypeRegistry.lookupByType(type);
      }
      if (!parameterType) {
        parameterType = parameterTypeRegistry.lookupByRegexp(captureGroupPattern);
      }
      if (!parameterType) {
        parameterType = parameterTypeRegistry.createAnonymousLookup(function (s) {
          return s;
        });
      }
      this._parameterTypes.push(parameterType);
    }
  }

  _createClass(RegularExpression, [{
    key: 'match',
    value: function match(text) {
      return buildArguments(this._regexp, text, this._parameterTypes);
    }
  }, {
    key: 'getSource',
    value: function getSource() {
      return this._regexp.toString();
    }
  }]);

  return RegularExpression;
}();

module.exports = RegularExpression;