'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Regex = require('becke-ch--regex--s0-0-v1--base--pl--lib');
var GroupBuilder = require('./group_builder');

var TreeRegexp = function () {
  function TreeRegexp(regexp) {
    _classCallCheck(this, TreeRegexp);

    this._re = 'string' === typeof regexp ? new RegExp(regexp) : regexp;
    this._regex = new Regex(this._re);

    var stack = [new GroupBuilder()];
    var last = null;
    var nonCapturingMaybe = false;
    this._re.source.split('').forEach(function (c) {
      if (c === '(' && last !== '\\') {
        stack.push(new GroupBuilder());
        nonCapturingMaybe = false;
      } else if (c === ')' && last !== '\\') {
        var gb = stack.pop();
        if (gb.capturing) {
          stack[stack.length - 1].add(gb);
        } else {
          gb.moveChildrenTo(stack[stack.length - 1]);
        }
        nonCapturingMaybe = false;
      } else if (c === '?' && last === '(') {
        nonCapturingMaybe = true;
      } else if (c === ':' && nonCapturingMaybe) {
        stack[stack.length - 1].setNonCapturing();
        nonCapturingMaybe = false;
      }
      last = c;
    });
    this._groupBuilder = stack.pop();
  }

  _createClass(TreeRegexp, [{
    key: 'match',
    value: function match(s) {
      var match = this._regex.exec(s);
      if (!match) return null;
      var groupIndex = 0;
      var nextGroupIndex = function nextGroupIndex() {
        return groupIndex++;
      };
      return this._groupBuilder.build(match, nextGroupIndex);
    }
  }, {
    key: 'regexp',
    get: function get() {
      return this._re;
    }
  }]);

  return TreeRegexp;
}();

module.exports = TreeRegexp;