"use strict";

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

(function (factory) {
    if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === "object" && _typeof(module.exports) === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    } else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "underscore", "./StepBinding", "./BindingRegistry", "./ManagedScenarioContext"], factory);
    }
})(function (require, exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", { value: true });
    var _ = require("underscore");
    var StepBinding_1 = require("./StepBinding");
    var BindingRegistry_1 = require("./BindingRegistry");
    var ManagedScenarioContext_1 = require("./ManagedScenarioContext");
    var cucumberSys = require("cucumber");
    /**
     * The property name of the current scenario context that will be attached to the Cucumber
     * world object.
     */
    var SCENARIO_CONTEXT_SLOTNAME = "__SCENARIO_CONTEXT";
    /**
     * A set of step patterns that have been registered with Cucumber.
     *
     * In order to support scoped (or tagged) step definitions, we must ensure that any step binding is
     * only registered with Cucumber once. The binding function for that step pattern then becomes
     * responsible for looking up and execuing the step binding based on the context that is in scope at
     * the point of invocation.
     */
    var stepPatternRegistrations = new Map();
    /**
     * A class decorator that marks the associated class as a CucumberJS binding.
     *
     * @param requiredContextTypes An optional array of Types that will be created and passed into the created
     * object for each scenario.
     *
     * An instance of the decorated class will be created for each scenario.
     */
    function binding(requiredContextTypes) {
        return function (target) {
            cucumberSys.defineSupportCode(function (sc) {
                ensureSystemBindings(sc);
                var bindingRegistry = BindingRegistry_1.BindingRegistry.instance;
                bindingRegistry.registerContextTypesForTarget(target.prototype, requiredContextTypes);
                bindingRegistry.getStepBindingsForTarget(target.prototype).forEach(function (stepBinding) {
                    if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.StepDefinitions) {
                        var stepBindingFlags = stepPatternRegistrations.get(stepBinding.stepPattern.toString());
                        if (stepBindingFlags === undefined) {
                            stepBindingFlags = StepBinding_1.StepBindingFlags.none;
                        }
                        if (stepBindingFlags & stepBinding.bindingType) return;
                        bindStepDefinition(sc, stepBinding);
                        stepPatternRegistrations.set(stepBinding.stepPattern.toString(), stepBindingFlags | stepBinding.bindingType);
                    } else if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.Hooks) {
                        bindHook(sc, stepBinding);
                    }
                });
            });
            return target;
        };
    }
    exports.binding = binding;
    /**
     * Ensures that the 'cucumber-tsflow' hooks are bound to Cucumber.
     *
     * @param cucumber The cucumber object.
     *
     * The hooks will only be registered with Cucumber once regardless of which binding invokes the
     * function.
     */
    var ensureSystemBindings = _.once(function (cucumber) {
        cucumber.Before(function (scenario) {
            this[SCENARIO_CONTEXT_SLOTNAME] = new ManagedScenarioContext_1.ManagedScenarioContext(scenario.name, _.map(scenario.tags, function (tag) {
                return tag.name;
            }));
            ;
        });
        cucumber.After(function () {
            var scenarioContext = this[SCENARIO_CONTEXT_SLOTNAME];
            if (scenarioContext) {
                scenarioContext.dispose();
            }
        });
        // Decorate the Cucumber step definition snippet builder so that it uses our syntax
        // let currentSnippetBuilder = cucumberSys.SupportCode.StepDefinitionSnippetBuilder;
        // cucumberSys.SupportCode.StepDefinitionSnippetBuilder = function (step, syntax) {
        //     return currentSnippetBuilder(step, {
        //         build: function (functionName: string, pattern, parameters, comment) {
        //             let callbackName = parameters[parameters.length - 1];
        //             return `@${functionName.toLowerCase()}(${pattern})\n` +
        //                    `public ${functionName}XXX (${parameters.join(", ")}): void {\n` +
        //                    `  // ${comment}\n` +
        //                    `  ${callbackName}.pending();\n` +
        //                    `}\n`;
        //         }
        //     });
        // }
    });
    /**
     * Binds a step definition to Cucumber.
     *
     * @param cucumber The cucumber object.
     * @param stepBinding The [[StepBinding]] that represents a 'given', 'when', or 'then' step definition.
     */
    function bindStepDefinition(cucumber, stepBinding) {
        var bindingFunc = function bindingFunc() {
            var bindingRegistry = BindingRegistry_1.BindingRegistry.instance;
            var scenarioContext = this[SCENARIO_CONTEXT_SLOTNAME];
            var matchingStepBindings = bindingRegistry.getStepBindings(stepBinding.stepPattern.toString(), scenarioContext.scenarioInfo.tags);
            if (matchingStepBindings.length > 1) {
                var message = "Ambiguous step definitions for '" + matchingStepBindings[0].stepPattern + "':\n";
                matchingStepBindings.forEach(function (matchingStepBinding) {
                    message = message + ("\t\t" + matchingStepBinding.targetPropertyKey + " (" + matchingStepBinding.callsite.toString() + ")\n");
                });
                return new Error(message);
            }
            var contextTypes = bindingRegistry.getContextTypesForTarget(matchingStepBindings[0].targetPrototype);
            var bindingObject = scenarioContext.getOrActivateBindingClass(matchingStepBindings[0].targetPrototype, contextTypes);
            bindingObject._worldObj = this;
            return bindingObject[matchingStepBindings[0].targetPropertyKey].apply(bindingObject, arguments);
        };
        Object.defineProperty(bindingFunc, "length", { value: stepBinding.argsLength });
        var bindingOptions = {};
        if (stepBinding.timeout) {
            bindingOptions.timeout = stepBinding.timeout;
        }
        if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.given) {
            cucumber.Given(stepBinding.stepPattern, bindingOptions, bindingFunc);
        } else if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.when) {
            cucumber.When(stepBinding.stepPattern, bindingOptions, bindingFunc);
        } else if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.then) {
            cucumber.Then(stepBinding.stepPattern, bindingOptions, bindingFunc);
        }
    }
    /**
     * Binds a hook to Cucumber.
     *
     * @param cucumber The cucumber object.
     * @param stepBinding The [[StepBinding]] that represents a 'before', or 'after', step definition.
     */
    function bindHook(cucumber, stepBinding) {
        var bindingFunc = function bindingFunc() {
            var scenarioContext = this[SCENARIO_CONTEXT_SLOTNAME];
            var contextTypes = BindingRegistry_1.BindingRegistry.instance.getContextTypesForTarget(stepBinding.targetPrototype);
            var bindingObject = scenarioContext.getOrActivateBindingClass(stepBinding.targetPrototype, contextTypes);
            bindingObject._worldObj = this;
            return bindingObject[stepBinding.targetPropertyKey].apply(bindingObject, arguments);
        };
        Object.defineProperty(bindingFunc, "length", { value: stepBinding.argsLength });
        var bindingOptions = {};
        if (stepBinding.tag !== BindingRegistry_1.DEFAULT_TAG) {
            bindingOptions.tags = stepBinding.tag;
        }
        if (stepBinding.timeout) {
            bindingOptions.timeout = stepBinding.timeout;
        }
        if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.before) {
            cucumber.Before(bindingOptions, bindingFunc);
        } else if (stepBinding.bindingType & StepBinding_1.StepBindingFlags.after) {
            cucumber.After(bindingOptions, bindingFunc);
        }
    }
});
//# sourceMappingURL=BindingDecorator.js.map