"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function (factory) {
    if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === "object" && _typeof(module.exports) === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    } else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "underscore"], factory);
    }
})(function (require, exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", { value: true });
    var _ = require("underscore");
    /**
     * Represents the default step pattern.
     */
    exports.DEFAULT_STEP_PATTERN = "/.*/";
    /**
     * Represents the default tag.
     */
    exports.DEFAULT_TAG = "*";
    /**
     * A metadata registry that captures information about bindings and their bound step bindings.
     */

    var BindingRegistry = function () {
        function BindingRegistry() {
            _classCallCheck(this, BindingRegistry);

            this._bindings = new Map();
            this._targetBindings = new Map();
        }
        /**
         * Gets the binding registry singleton.
         *
         * @returns A [[BindingRegistry]].
         */


        _createClass(BindingRegistry, [{
            key: "registerContextTypesForTarget",

            /**
             * Updates the binding registry with information about the context types required by a
             * binding class.
             *
             * @param targetPrototype The class representing the binding (constructor function).
             * @param contextTypes An array of [[ContextType]] that define the types of objects that
             * should be injected into the binding class during a scenario execution.
             */
            value: function registerContextTypesForTarget(targetPrototype, contextTypes) {
                if (!contextTypes) return;
                var targetDecorations = this._targetBindings.get(targetPrototype);
                if (!targetDecorations) {
                    targetDecorations = {
                        stepBindings: [],
                        contextTypes: []
                    };
                    this._targetBindings.set(targetPrototype, targetDecorations);
                }
                targetDecorations.contextTypes = contextTypes;
            }
            /**
             * Retrieves the context types that have been registered for a given binding class.
             *
             * @param targetPrototype The class representing the binding (constructor function).
             *
             * @returns An array of [[ContextType]] that have been registered for the specified
             * binding class.
             */

        }, {
            key: "getContextTypesForTarget",
            value: function getContextTypesForTarget(targetPrototype) {
                var targetBinding = this._targetBindings.get(targetPrototype);
                if (!targetBinding) return [];
                return targetBinding.contextTypes;
            }
            /**
             * Updates the binding registry indexes with a step binding.
             *
             * @param stepBinding The step binding that is to be registered with the binding registry.
             */

        }, {
            key: "registerStepBinding",
            value: function registerStepBinding(stepBinding) {
                if (!stepBinding.tag) {
                    stepBinding.tag = exports.DEFAULT_TAG;
                }
                var stepPattern = stepBinding.stepPattern ? stepBinding.stepPattern.toString() : exports.DEFAULT_STEP_PATTERN;
                var tagMap = this._bindings.get(stepPattern);
                if (!tagMap) {
                    tagMap = new Map();
                    this._bindings.set(stepPattern, tagMap);
                }
                var stepBindings = tagMap.get(stepBinding.tag);
                if (!stepBindings) {
                    stepBindings = [];
                    tagMap.set(stepBinding.tag, stepBindings);
                }
                stepBindings.push(stepBinding);
                // Index the step binding for the target
                var targetBinding = this._targetBindings.get(stepBinding.targetPrototype);
                if (!targetBinding) {
                    targetBinding = {
                        stepBindings: [],
                        contextTypes: []
                    };
                    this._targetBindings.set(stepBinding.targetPrototype, targetBinding);
                }
                targetBinding.stepBindings.push(stepBinding);
            }
            /**
             * Retrieves the step bindings that have been registered for a given binding class.
             *
             * @param targetPrototype The class representing the binding (constructor function).
             *
             * @returns An array of [[StepBinding]] objects that have been registered for the specified
             * binding class.
             */

        }, {
            key: "getStepBindingsForTarget",
            value: function getStepBindingsForTarget(targetPrototype) {
                var targetBinding = this._targetBindings.get(targetPrototype);
                if (!targetBinding) return [];
                return targetBinding.stepBindings;
            }
            /**
             * Retrieves the step bindings for a given step pattern and collection of tag names.
             *
             * @param stepPattern The step pattern to search.
             * @param tags An array of [[TagName]] to search.
             *
             * @returns An array of [[StepBinding]] that map to the given step pattern and set of tag names.
             */

        }, {
            key: "getStepBindings",
            value: function getStepBindings(stepPattern, tags) {
                var tagMap = this._bindings.get(stepPattern);
                if (!tagMap) return [];
                var matchingStepBindings = this.mapTagNamesToStepBindings(tags, tagMap);
                if (matchingStepBindings.length > 0) return matchingStepBindings;
                return this.mapTagNamesToStepBindings(["*"], tagMap);
            }
            /**
             * Maps an array of tag names to an array of associated step bindings.
             *
             * @param tags An array of [[TagName]].
             * @param tagMap The map of [[TagName]] -> [[StepBinding]] to use when mapping.
             *
             * @returns An array of [[StepBinding]].
             */

        }, {
            key: "mapTagNamesToStepBindings",
            value: function mapTagNamesToStepBindings(tags, tagMap) {
                var matchingStepBindings = _.flatten(_.map(tags, function (tag) {
                    return tagMap.get(tag);
                }));
                return _.reject(matchingStepBindings, function (stepBinding) {
                    return stepBinding === undefined;
                });
            }
        }], [{
            key: "instance",
            get: function get() {
                var BINDING_REGISTRY_SLOTNAME = "__CUCUMBER_TSFLOW_BINDINGREGISTRY";
                var registry = global[BINDING_REGISTRY_SLOTNAME];
                if (!registry) {
                    global[BINDING_REGISTRY_SLOTNAME] = new BindingRegistry();
                }
                return registry || global[BINDING_REGISTRY_SLOTNAME];
            }
        }]);

        return BindingRegistry;
    }();

    exports.BindingRegistry = BindingRegistry;
});
//# sourceMappingURL=BindingRegistry.js.map