"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function (factory) {
    if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === "object" && _typeof(module.exports) === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", { value: true });
    var stack = require("callsite");
    /**
     * Represents a callsite of where a step binding is being applied.
     */

    var Callsite = function () {
        /**
         * Initializes a new [[Callsite]].
         *
         * @param filename The filename of the callsite.
         * @param lineNumber The line number of the callsite.
         */
        function Callsite(filename, lineNumber) {
            _classCallCheck(this, Callsite);

            this.filename = filename;
            this.lineNumber = lineNumber;
        }
        /**
         * Returns a string representation of the callsite.
         *
         * @returns A string representing the callsite formatted with the filename and line
         * number.
         */


        _createClass(Callsite, [{
            key: "toString",
            value: function toString() {
                return this.filename + ":" + this.lineNumber;
            }
            /**
             * Captures the current [[Callsite]] object.
             */

        }], [{
            key: "capture",
            value: function capture() {
                var stackFrame = stack()[2];
                return new Callsite(stackFrame.getFileName(), stackFrame.getLineNumber());
            }
        }]);

        return Callsite;
    }();

    exports.Callsite = Callsite;
});
//# sourceMappingURL=Callsite.js.map