'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

(function (dependencies, factory) {
    if ((typeof module === 'undefined' ? 'undefined' : _typeof(module)) === 'object' && _typeof(module.exports) === 'object') {
        var v = factory(require, exports);if (v !== undefined) module.exports = v;
    } else if (typeof define === 'function' && define.amd) {
        define(dependencies, factory);
    }
})(["require", "exports", "lodash"], function (require, exports) {
    "use strict";

    var lodash = require("lodash");
    /**
     * Ensures that the decorated function is invoked only once.
     *
     * @remakrs
     * Any subsequent invocations of the decorated function return the cached result from
     * the very first invocation.
     */
    function once() {
        function createWrappedFunction(target, propertyKey, funcToWrap) {
            return function () {
                var wrappedFunc = undefined;
                if (!this) {
                    wrappedFunc = target[propertyKey];
                    if (!wrappedFunc) {
                        wrappedFunc = lodash.once(funcToWrap);
                        Object.defineProperty(target, propertyKey, {
                            enumerable: false,
                            value: wrappedFunc
                        });
                    }
                } else {
                    wrappedFunc = this[propertyKey];
                    if (!wrappedFunc) {
                        wrappedFunc = lodash.once(funcToWrap);
                        Object.defineProperty(this, propertyKey, {
                            enumerable: false,
                            value: wrappedFunc
                        });
                    }
                }

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                return wrappedFunc.apply(this, args);
            };
        }
        return function (target, propertyKey, descriptor) {
            descriptor.value = createWrappedFunction(target, propertyKey.toString() + '_once', descriptor.value);
            return descriptor;
        };
    }
    exports.once = once;
});
//# sourceMappingURL=LodashUtilities.js.map