"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

(function (factory) {
    if ((typeof module === "undefined" ? "undefined" : _typeof(module)) === "object" && _typeof(module.exports) === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    } else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "underscore", "./ScenarioContext", "./ScenarioContext"], factory);
    }
})(function (require, exports) {
    "use strict";

    function __export(m) {
        for (var p in m) {
            if (!exports.hasOwnProperty(p)) exports[p] = m[p];
        }
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    var _ = require("underscore");
    var ScenarioContext_1 = require("./ScenarioContext");
    /**
     * Represents a [[ScenarioContext]] implementation that manages a collection of context objects that
     * are created and used by binding classes during a running Cucumber scenario.
     */

    var ManagedScenarioContext = function () {
        function ManagedScenarioContext(scenarioTitle, tags) {
            _classCallCheck(this, ManagedScenarioContext);

            this._activeObjects = new Map();
            this._scenarioInfo = new ScenarioContext_1.ScenarioInfo(scenarioTitle, tags);
        }
        /**
         * Gets information about the scenario.
         *
         */


        _createClass(ManagedScenarioContext, [{
            key: "getOrActivateBindingClass",
            value: function getOrActivateBindingClass(targetPrototype, contextTypes) {
                var _this = this;

                return this.getOrActivateObject(targetPrototype, function () {
                    return _this.activateBindingClass(targetPrototype, contextTypes);
                });
            }
        }, {
            key: "dispose",
            value: function dispose() {
                this._activeObjects.forEach(function (value) {
                    if (typeof value["dispose"] === "function") {
                        value["dispose"]();
                    }
                });
            }
        }, {
            key: "activateBindingClass",
            value: function activateBindingClass(targetPrototype, contextTypes) {
                var _this2 = this;

                var invokeBindingConstructor = function invokeBindingConstructor(args) {
                    switch (contextTypes.length) {
                        case 0:
                            return new targetPrototype.constructor();
                        case 1:
                            return new targetPrototype.constructor(args[0]);
                        case 2:
                            return new targetPrototype.constructor(args[0], args[1]);
                        case 3:
                            return new targetPrototype.constructor(args[0], args[1], args[2]);
                        case 4:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3]);
                        case 5:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4]);
                        case 6:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4], args[5]);
                        case 7:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
                        case 8:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
                        case 9:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
                        case 10:
                            return new targetPrototype.constructor(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
                    }
                };
                var contextObjects = _.map(contextTypes, function (contextType) {
                    return _this2.getOrActivateObject(contextType.prototype, function () {
                        return new contextType();
                    });
                });
                return invokeBindingConstructor(contextObjects);
            }
        }, {
            key: "getOrActivateObject",
            value: function getOrActivateObject(targetPrototype, activatorFunc) {
                var activeObject = this._activeObjects.get(targetPrototype);
                if (activeObject) return activeObject;
                activeObject = activatorFunc();
                this._activeObjects.set(targetPrototype, activeObject);
                return activeObject;
            }
        }, {
            key: "scenarioInfo",
            get: function get() {
                return this._scenarioInfo;
            }
        }]);

        return ManagedScenarioContext;
    }();

    exports.ManagedScenarioContext = ManagedScenarioContext;
    __export(require("./ScenarioContext"));
});
//# sourceMappingURL=ManagedScenarioContext.js.map