(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var stack = require("callsite");
    /**
     * Represents a callsite of where a step binding is being applied.
     */
    class Callsite {
        /**
         * Initializes a new [[Callsite]].
         *
         * @param filename The filename of the callsite.
         * @param lineNumber The line number of the callsite.
         */
        constructor(filename, lineNumber) {
            this.filename = filename;
            this.lineNumber = lineNumber;
        }
        /**
         * Returns a string representation of the callsite.
         *
         * @returns A string representing the callsite formatted with the filename and line
         * number.
         */
        toString() {
            return `${this.filename}:${this.lineNumber}`;
        }
        /**
         * Captures the current [[Callsite]] object.
         */
        static capture() {
            let stackFrame = stack()[2];
            return new Callsite(stackFrame.getFileName(), stackFrame.getLineNumber());
        }
    }
    exports.Callsite = Callsite;
});
//# sourceMappingURL=Callsite.js.map