(function (dependencies, factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(dependencies, factory);
    }
})(["require", "exports", "inversify", "./KernelContext"], function (require, exports) {
    "use strict";
    const inversify_1 = require("inversify");
    const KernelContext_1 = require("./KernelContext");
    function contextProvider() {
        return function (target) {
            inversify_1.injectable()(target);
            KernelContext_1.KernelContext.current.kernel.bind(target).toSelf();
        };
    }
    exports.contextProvider = contextProvider;
});
//# sourceMappingURL=ContextProviderDecorator.js.map