(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./BindingRegistry", "./StepBinding", "./Callsite"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const BindingRegistry_1 = require("./BindingRegistry");
    const StepBinding_1 = require("./StepBinding");
    const Callsite_1 = require("./Callsite");
    /**
     * A method decorator that marks the associated function as a 'Before Scenario' step. The function is
     * executed before each scenario.
     *
     * @param tag An optional tag.
     */
    function before(tag, timeout) {
        let callsite = Callsite_1.Callsite.capture();
        return function (target, propertyKey, descriptor) {
            let stepBinding = {
                stepPattern: undefined,
                bindingType: StepBinding_1.StepBindingFlags.before,
                targetPrototype: target,
                targetPropertyKey: propertyKey,
                argsLength: target[propertyKey]["length"],
                callsite: callsite
            };
            if (tag) {
                stepBinding.tag = tag[0] === "@" ? tag : `@${tag}`;
            }
            if (timeout) {
                stepBinding.timeout = timeout;
            }
            BindingRegistry_1.BindingRegistry.instance.registerStepBinding(stepBinding);
            return descriptor;
        };
    }
    exports.before = before;
    /**
     * A method decorator that marks the associated function as an 'After Scenario' step. The function is
     * executed after each scenario.
     *
     * @param tag An optional tag.
     */
    function after(tag, timeout) {
        let callsite = Callsite_1.Callsite.capture();
        return function (target, propertyKey, descriptor) {
            let stepBinding = {
                stepPattern: undefined,
                bindingType: StepBinding_1.StepBindingFlags.after,
                targetPrototype: target,
                targetPropertyKey: propertyKey,
                argsLength: target[propertyKey]["length"],
                callsite: callsite
            };
            if (tag) {
                stepBinding.tag = tag[0] === "@" ? tag : `@${tag}`;
            }
            if (timeout) {
                stepBinding.timeout = timeout;
            }
            BindingRegistry_1.BindingRegistry.instance.registerStepBinding(stepBinding);
            return descriptor;
        };
    }
    exports.after = after;
});
//# sourceMappingURL=HookDecorators.js.map