import { Kernel } from "inversify";
/**
 * Encapsulates all the Inversify context being applied during binding execution.
 */
export declare class KernelContext {
    private underlyingKernel;
    /**
     * Initializes a new Kernel Context object.
     */
    constructor();
    /**
     * Gets the underlying Inversify Kernel being used for Dependency Injection operations.
     *
     * @returns A {@linkcode Kernel}.
     */
    readonly kernel: Kernel;
    /**
     * Gets the current Kernel Context.
     *
     * @returns A {@linkcode KernelContext}.
     */
    static readonly current: KernelContext;
    /**
     * Gets or creates the Kernel Context instance.
     *
     * @returns A {@linkcode KernelContext}.
     *
     * @remarks
     * The Kernel Context returned from the first invocation is returned on all subsequent
     * invocations to {@linkcode KernelContext#getOrCreateInstance}.
     */
    private static getOrCreateInstance();
}
