(function (dependencies, factory) {
    if (typeof module === 'object' && typeof module.exports === 'object') {
        var v = factory(require, exports); if (v !== undefined) module.exports = v;
    }
    else if (typeof define === 'function' && define.amd) {
        define(dependencies, factory);
    }
})(["require", "exports", "lodash"], function (require, exports) {
    "use strict";
    const lodash = require("lodash");
    /**
     * Ensures that the decorated function is invoked only once.
     *
     * @remakrs
     * Any subsequent invocations of the decorated function return the cached result from
     * the very first invocation.
     */
    function once() {
        function createWrappedFunction(target, propertyKey, funcToWrap) {
            return function (...args) {
                let wrappedFunc = undefined;
                if (!this) {
                    wrappedFunc = target[propertyKey];
                    if (!wrappedFunc) {
                        wrappedFunc = lodash.once(funcToWrap);
                        Object.defineProperty(target, propertyKey, {
                            enumerable: false,
                            value: wrappedFunc
                        });
                    }
                }
                else {
                    wrappedFunc = this[propertyKey];
                    if (!wrappedFunc) {
                        wrappedFunc = lodash.once(funcToWrap);
                        Object.defineProperty(this, propertyKey, {
                            enumerable: false,
                            value: wrappedFunc
                        });
                    }
                }
                return wrappedFunc.apply(this, args);
            };
        }
        return function (target, propertyKey, descriptor) {
            descriptor.value = createWrappedFunction(target, `${propertyKey.toString()}_once`, descriptor.value);
            return descriptor;
        };
    }
    exports.once = once;
});
//# sourceMappingURL=LodashUtilities.js.map