import { ContextType } from "./Types";
import { ScenarioInfo, ScenarioContext } from "./ScenarioContext";
/**
 * Represents a [[ScenarioContext]] implementation that manages a collection of context objects that
 * are created and used by binding classes during a running Cucumber scenario.
 */
export declare class ManagedScenarioContext implements ScenarioContext {
    private _scenarioInfo;
    private _activeObjects;
    constructor(scenarioTitle: string, tags: string[]);
    /**
     * Gets information about the scenario.
     *
     */
    readonly scenarioInfo: ScenarioInfo;
    getOrActivateBindingClass(targetPrototype: any, contextTypes: ContextType[]): any;
    dispose(): void;
    private activateBindingClass(targetPrototype, contextTypes);
    private getOrActivateObject(targetPrototype, activatorFunc);
}
export * from "./ScenarioContext";
