/**
 * The CucumberJS step binding types.
 */
export declare enum StepBindingFlags {
    /**
     * No bindings.
     */
    none = 0,
    /**
     * A 'Given' step definition binding.
     */
    given = 1,
    /**
     * A 'When' step definition binding.
     */
    when = 2,
    /**
     * A 'Then' step definition binding.
     */
    then = 4,
    /**
     * A 'Before' hook binding.
     */
    before = 8,
    /**
     * An 'After' hook binding.
     */
    after = 16,
    /**
     * All step definition bindings.
     */
    StepDefinitions = 7,
    /**
     * All hook bindings.
     */
    Hooks = 24,
}
