(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./BindingRegistry", "./StepBinding", "./Callsite"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    const BindingRegistry_1 = require("./BindingRegistry");
    const StepBinding_1 = require("./StepBinding");
    const Callsite_1 = require("./Callsite");
    /**
     * A method decorator that marks the associated function as a 'Given' step.
     *
     * @param stepPattern The regular expression that will be used to match steps.
     * @param tag An optional tag.
     * @param timeout An optional timeout.
     */
    function given(stepPattern, tag, timeout) {
        let callsite = Callsite_1.Callsite.capture();
        return function (target, propertyKey, descriptor) {
            let stepBinding = {
                stepPattern: stepPattern,
                bindingType: StepBinding_1.StepBindingFlags.given,
                targetPrototype: target,
                targetPropertyKey: propertyKey,
                argsLength: target[propertyKey]["length"],
                callsite: callsite
            };
            if (tag) {
                stepBinding.tag = tag[0] === "@" ? tag : `@${tag}`;
            }
            if (timeout) {
                stepBinding.timeout = timeout;
            }
            BindingRegistry_1.BindingRegistry.instance.registerStepBinding(stepBinding);
            return descriptor;
        };
    }
    exports.given = given;
    /**
     * A method decorator that marks the associated function as a 'When' step.
     *
     * @param stepPattern The regular expression that will be used to match steps.
     * @param tag An optional tag.
     * @param timeout An optional timeout.
     */
    function when(stepPattern, tag, timeout) {
        let callsite = Callsite_1.Callsite.capture();
        return function (target, propertyKey, descriptor) {
            let stepBinding = {
                stepPattern: stepPattern,
                bindingType: StepBinding_1.StepBindingFlags.when,
                targetPrototype: target,
                targetPropertyKey: propertyKey,
                argsLength: target[propertyKey]["length"],
                callsite: callsite
            };
            if (tag) {
                stepBinding.tag = tag[0] === "@" ? tag : `@${tag}`;
            }
            if (timeout) {
                stepBinding.timeout = timeout;
            }
            BindingRegistry_1.BindingRegistry.instance.registerStepBinding(stepBinding);
            return descriptor;
        };
    }
    exports.when = when;
    /**
     * A method decorator that marks the associated function as a 'Then' step.
     *
     * @param stepPattern The regular expression that will be used to match steps.
     * @param tag An optional tag.
     * @param timeout An optional timeout.
     */
    function then(stepPattern, tag, timeout) {
        let callsite = Callsite_1.Callsite.capture();
        return function (target, propertyKey, descriptor) {
            let stepBinding = {
                stepPattern: stepPattern,
                bindingType: StepBinding_1.StepBindingFlags.then,
                targetPrototype: target,
                targetPropertyKey: propertyKey,
                argsLength: target[propertyKey]["length"],
                callsite: callsite
            };
            if (tag) {
                stepBinding.tag = tag[0] === "@" ? tag : `@${tag}`;
            }
            if (timeout) {
                stepBinding.timeout = timeout;
            }
            BindingRegistry_1.BindingRegistry.instance.registerStepBinding(stepBinding);
            return descriptor;
        };
    }
    exports.then = then;
});
//# sourceMappingURL=StepDefinitionDecorators.js.map