# Cucumber.js

[![TravisCI](https://img.shields.io/travis/cucumber/cucumber-js/master.svg?label=travis-ci)](https://travis-ci.org/cucumber/cucumber-js/branches)
[![AppVeyor Status](https://img.shields.io/appveyor/ci/charlierudolph/cucumber-js/master.svg?label=appveyor)](https://ci.appveyor.com/project/charlierudolph/cucumber-js/history)
[![Dependencies](https://david-dm.org/cucumber/cucumber-js.svg)](https://david-dm.org/cucumber/cucumber-js)

[Cucumber](https://cucumber.io) is a tool for running automated tests written in plain language. Because they're
written in plain language, they can be read by anyone on your team. Because they can be
read by anyone, you can use them to help improve communication, collaboration and trust on
your team.

Cucumber.js is the JavaScript implementation of Cucumber and runs on both Node.js (4 and above) and *modern* web browsers.

## Try it now

We've put a demo of Cucumber.js to [run in your browser](http://cucumber.github.io/cucumber-js/). Why don't you give it a try before anything else?

## Help & support

* Chat: [Gitter](https://gitter.im/cucumber/cucumber-js)
* Google Groups: [cukes](https://groups.google.com/group/cukes)
* Website: [cucumber.io](https://cucumber.io)
* Twitter: [@cucumberbdd](https://twitter.com/cucumberbdd/)

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for info on contributing to Cucumber.js.

## Code of Conduct

Everyone interacting in this codebase and issue tracker is expected to follow the Cucumber [code of conduct](https://github.com/cucumber/cucumber/blob/master/CODE_OF_CONDUCT.md).

## Install

[![npm downloads](https://img.shields.io/npm/dm/cucumber.svg?style=flat-square)](http://npm-stat.com/charts.html?package=cucumber&from=2015-09-01)


### Node

Cucumber.js is available as an npm module.

``` shell
$ npm install cucumber
```

### Browser

* Grab the browserified code from the latest release in the [dist](/dist) folder

## Documentation

The following documentation is for `2.x`. Documentation for `1.x`  is available [here](https://github.com/cucumber/cucumber-js/tree/1.x).

* [CLI](/docs/cli.md)
* [Custom Formatters](/docs/custom_formatters.md)
* [NodeJs Example](/docs/nodejs_example.md)
* Support Files
  * [World](/docs/support_files/world.md)
  * [Step Definitions](/docs/support_files/step_definitions.md)
  * [Hooks](/docs/support_files/hooks.md)
  * [Timeouts](docs/support_files/timeouts.md)
  * [Data Table Interface](/docs/support_files/data_table_interface.md)
  * [Attachments](/docs/support_files/attachments.md)
  * [Event Handlers](/docs/support_files/event_handlers.md)
  * [API Reference](/docs/support_files/api_reference.md)
* [FAQ](/docs/faq.md)
