'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _get_color_fns = require('./get_color_fns');

var _get_color_fns2 = _interopRequireDefault(_get_color_fns);

var _javascript_snippet_syntax = require('./step_definition_snippet_builder/javascript_snippet_syntax');

var _javascript_snippet_syntax2 = _interopRequireDefault(_javascript_snippet_syntax);

var _json_formatter = require('./json_formatter');

var _json_formatter2 = _interopRequireDefault(_json_formatter);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _pretty_formatter = require('./pretty_formatter');

var _pretty_formatter2 = _interopRequireDefault(_pretty_formatter);

var _progress_bar_formatter = require('./progress_bar_formatter');

var _progress_bar_formatter2 = _interopRequireDefault(_progress_bar_formatter);

var _progress_formatter = require('./progress_formatter');

var _progress_formatter2 = _interopRequireDefault(_progress_formatter);

var _rerun_formatter = require('./rerun_formatter');

var _rerun_formatter2 = _interopRequireDefault(_rerun_formatter);

var _snippets_formatter = require('./snippets_formatter');

var _snippets_formatter2 = _interopRequireDefault(_snippets_formatter);

var _step_definition_snippet_builder = require('./step_definition_snippet_builder');

var _step_definition_snippet_builder2 = _interopRequireDefault(_step_definition_snippet_builder);

var _summary_formatter = require('./summary_formatter');

var _summary_formatter2 = _interopRequireDefault(_summary_formatter);

var _usage_formatter = require('./usage_formatter');

var _usage_formatter2 = _interopRequireDefault(_usage_formatter);

var _usage_json_formatter = require('./usage_json_formatter');

var _usage_json_formatter2 = _interopRequireDefault(_usage_json_formatter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FormatterBuilder = function () {
  function FormatterBuilder() {
    (0, _classCallCheck3.default)(this, FormatterBuilder);
  }

  (0, _createClass3.default)(FormatterBuilder, null, [{
    key: 'build',
    value: function build(type, options) {
      var Formatter = FormatterBuilder.getConstructorByType(type, options);
      var extendedOptions = _lodash2.default.assign({}, options, {
        colorFns: (0, _get_color_fns2.default)(options.colorsEnabled),
        snippetBuilder: FormatterBuilder.getStepDefinitionSnippetBuilder(options)
      });
      return new Formatter(extendedOptions);
    }
  }, {
    key: 'getConstructorByType',
    value: function getConstructorByType(type, options) {
      switch (type) {
        case 'json':
          return _json_formatter2.default;
        case 'pretty':
          return _pretty_formatter2.default;
        case 'progress':
          return _progress_formatter2.default;
        case 'progress-bar':
          return _progress_bar_formatter2.default;
        case 'rerun':
          return _rerun_formatter2.default;
        case 'snippets':
          return _snippets_formatter2.default;
        case 'summary':
          return _summary_formatter2.default;
        case 'usage':
          return _usage_formatter2.default;
        case 'usage-json':
          return _usage_json_formatter2.default;
        default:
          return FormatterBuilder.loadCustomFormatter(type, options);
      }
    }
  }, {
    key: 'getStepDefinitionSnippetBuilder',
    value: function getStepDefinitionSnippetBuilder(_ref) {
      var cwd = _ref.cwd,
          snippetInterface = _ref.snippetInterface,
          snippetSyntax = _ref.snippetSyntax,
          supportCodeLibrary = _ref.supportCodeLibrary;

      if (!snippetInterface) {
        snippetInterface = 'callback';
      }
      var Syntax = _javascript_snippet_syntax2.default;
      if (snippetSyntax) {
        var fullSyntaxPath = _path2.default.resolve(cwd, snippetSyntax);
        Syntax = require(fullSyntaxPath);
      }
      return new _step_definition_snippet_builder2.default({
        snippetSyntax: new Syntax(snippetInterface),
        parameterTypeRegistry: supportCodeLibrary.parameterTypeRegistry
      });
    }
  }, {
    key: 'loadCustomFormatter',
    value: function loadCustomFormatter(customFormatterPath, _ref2) {
      var cwd = _ref2.cwd;

      var fullCustomFormatterPath = _path2.default.resolve(cwd, customFormatterPath);
      var CustomFormatter = require(fullCustomFormatterPath);
      if (typeof CustomFormatter === 'function') {
        return CustomFormatter;
      } else if (CustomFormatter && typeof CustomFormatter.default === 'function') {
        return CustomFormatter.default;
      } else {
        throw new Error('Custom formatter (' + customFormatterPath + ') does not export a function');
      }
    }
  }]);
  return FormatterBuilder;
}();

exports.default = FormatterBuilder;