'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Then = exports.When = exports.Given = exports.setWorldConstructor = exports.setDefinitionFunctionWrapper = exports.setDefaultTimeout = exports.registerListener = exports.registerHandler = exports.Before = exports.After = exports.defineParameterType = exports.addTransform = exports.defineStep = exports.clearSupportCodeFns = exports.getSupportCodeFns = exports.defineSupportCode = exports.formatterHelpers = exports.UsageJsonFormatter = exports.UsageFormatter = exports.SupportCodeLibraryBuilder = exports.SummaryFormatter = exports.Status = exports.SnippetsFormatter = exports.ScenarioFilter = exports.Runtime = exports.RerunFormatter = exports.ProgressFormatter = exports.PrettyFormatter = exports.JsonFormatter = exports.FormatterBuilder = exports.Formatter = exports.FeatureParser = exports.Cli = undefined;

var _cli = require('./cli');

Object.defineProperty(exports, 'Cli', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_cli).default;
  }
});

var _feature_parser = require('./cli/feature_parser');

Object.defineProperty(exports, 'FeatureParser', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_feature_parser).default;
  }
});

var _formatter = require('./formatter');

Object.defineProperty(exports, 'Formatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_formatter).default;
  }
});

var _builder = require('./formatter/builder');

Object.defineProperty(exports, 'FormatterBuilder', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_builder).default;
  }
});

var _json_formatter = require('./formatter/json_formatter');

Object.defineProperty(exports, 'JsonFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_json_formatter).default;
  }
});

var _pretty_formatter = require('./formatter/pretty_formatter');

Object.defineProperty(exports, 'PrettyFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_pretty_formatter).default;
  }
});

var _progress_formatter = require('./formatter/progress_formatter');

Object.defineProperty(exports, 'ProgressFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_progress_formatter).default;
  }
});

var _rerun_formatter = require('./formatter/rerun_formatter');

Object.defineProperty(exports, 'RerunFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_rerun_formatter).default;
  }
});

var _runtime = require('./runtime');

Object.defineProperty(exports, 'Runtime', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_runtime).default;
  }
});

var _scenario_filter = require('./scenario_filter');

Object.defineProperty(exports, 'ScenarioFilter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_scenario_filter).default;
  }
});

var _snippets_formatter = require('./formatter/snippets_formatter');

Object.defineProperty(exports, 'SnippetsFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_snippets_formatter).default;
  }
});

var _status = require('./status');

Object.defineProperty(exports, 'Status', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_status).default;
  }
});

var _summary_formatter = require('./formatter/summary_formatter');

Object.defineProperty(exports, 'SummaryFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_summary_formatter).default;
  }
});

var _builder2 = require('./support_code_library/builder');

Object.defineProperty(exports, 'SupportCodeLibraryBuilder', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_builder2).default;
  }
});

var _usage_formatter = require('./formatter/usage_formatter');

Object.defineProperty(exports, 'UsageFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_usage_formatter).default;
  }
});

var _usage_json_formatter = require('./formatter/usage_json_formatter');

Object.defineProperty(exports, 'UsageJsonFormatter', {
  enumerable: true,
  get: function get() {
    return _interopRequireDefault(_usage_json_formatter).default;
  }
});

var _support_code_fns = require('./support_code_fns');

var _support_code_fns2 = _interopRequireDefault(_support_code_fns);

var _helpers = require('./formatter/helpers');

var formatterHelpers = _interopRequireWildcard(_helpers);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.formatterHelpers = formatterHelpers;
var defineSupportCode = exports.defineSupportCode = _support_code_fns2.default.add;
var getSupportCodeFns = exports.getSupportCodeFns = _support_code_fns2.default.get;
var clearSupportCodeFns = exports.clearSupportCodeFns = _support_code_fns2.default.reset;

var proxySupportCode = function proxySupportCode(name) {
  return function () {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return defineSupportCode(function (supportCodeContext) {
      return supportCodeContext[name].apply(supportCodeContext, args);
    });
  };
};

var defineStep = exports.defineStep = proxySupportCode('defineStep');
var addTransform = exports.addTransform = proxySupportCode('addTransform');
var defineParameterType = exports.defineParameterType = proxySupportCode('defineParameterType');
var After = exports.After = proxySupportCode('After');
var Before = exports.Before = proxySupportCode('Before');
var registerHandler = exports.registerHandler = proxySupportCode('registerHandler');
var registerListener = exports.registerListener = proxySupportCode('registerListener');
var setDefaultTimeout = exports.setDefaultTimeout = proxySupportCode('setDefaultTimeout');
var setDefinitionFunctionWrapper = exports.setDefinitionFunctionWrapper = proxySupportCode('setDefinitionFunctionWrapper');
var setWorldConstructor = exports.setWorldConstructor = proxySupportCode('setWorldConstructor');
var Given = exports.Given = defineStep;
var When = exports.When = defineStep;
var Then = exports.Then = defineStep;