'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _argv_parser = require('./argv_parser');

var _argv_parser2 = _interopRequireDefault(_argv_parser);

var _fs = require('mz/fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _path_expander = require('./path_expander');

var _path_expander2 = _interopRequireDefault(_path_expander);

var _option_splitter = require('./option_splitter');

var _option_splitter2 = _interopRequireDefault(_option_splitter);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ConfigurationBuilder = function () {
  (0, _createClass3.default)(ConfigurationBuilder, null, [{
    key: 'build',
    value: function () {
      var _ref = (0, _bluebird.coroutine)(function* (options) {
        var builder = new ConfigurationBuilder(options);
        return yield builder.build();
      });

      function build(_x) {
        return _ref.apply(this, arguments);
      }

      return build;
    }()
  }]);

  function ConfigurationBuilder(_ref2) {
    var argv = _ref2.argv,
        cwd = _ref2.cwd;
    (0, _classCallCheck3.default)(this, ConfigurationBuilder);

    this.cwd = cwd;
    this.pathExpander = new _path_expander2.default(cwd);

    var parsedArgv = _argv_parser2.default.parse(argv);
    this.args = parsedArgv.args;
    this.options = parsedArgv.options;
  }

  (0, _createClass3.default)(ConfigurationBuilder, [{
    key: 'build',
    value: function () {
      var _ref3 = (0, _bluebird.coroutine)(function* () {
        var listI18nKeywordsFor = this.options.i18nKeywords;
        var listI18nLanguages = !!this.options.i18nLanguages;
        var unexpandedFeaturePaths = yield this.getUnexpandedFeaturePaths();
        var featurePaths = [];
        var supportCodePaths = [];
        if (!listI18nKeywordsFor && !listI18nLanguages) {
          featurePaths = yield this.expandFeaturePaths(unexpandedFeaturePaths);
          var featureDirectoryPaths = this.getFeatureDirectoryPaths(featurePaths);
          var unexpandedSupportCodePaths = this.options.require.length > 0 ? this.options.require : featureDirectoryPaths;
          supportCodePaths = yield this.expandSupportCodePaths(unexpandedSupportCodePaths);
        }
        return {
          featureDefaultLanguage: this.options.language,
          featurePaths: featurePaths,
          formats: this.getFormats(),
          formatOptions: this.getFormatOptions(),
          listI18nKeywordsFor: listI18nKeywordsFor,
          listI18nLanguages: listI18nLanguages,
          profiles: this.options.profile,
          pickleFilterOptions: {
            featurePaths: unexpandedFeaturePaths,
            names: this.options.name,
            tagExpression: this.options.tags
          },
          runtimeOptions: {
            dryRun: !!this.options.dryRun,
            failFast: !!this.options.failFast,
            filterStacktraces: !this.options.backtrace,
            strict: !!this.options.strict,
            worldParameters: this.options.worldParameters
          },
          supportCodePaths: supportCodePaths
        };
      });

      function build() {
        return _ref3.apply(this, arguments);
      }

      return build;
    }()
  }, {
    key: 'expandFeaturePaths',
    value: function () {
      var _ref4 = (0, _bluebird.coroutine)(function* (featurePaths) {
        featurePaths = featurePaths.map(function (p) {
          return p.replace(/(:\d+)*$/g, '');
        }); // Strip line numbers
        return yield this.pathExpander.expandPathsWithExtensions(featurePaths, ['feature']);
      });

      function expandFeaturePaths(_x2) {
        return _ref4.apply(this, arguments);
      }

      return expandFeaturePaths;
    }()
  }, {
    key: 'getFeatureDirectoryPaths',
    value: function getFeatureDirectoryPaths(featurePaths) {
      var _this = this;

      var featureDirs = featurePaths.map(function (featurePath) {
        var featureDir = _path2.default.dirname(featurePath);
        var childDir = void 0;
        var parentDir = featureDir;
        while (childDir !== parentDir) {
          childDir = parentDir;
          parentDir = _path2.default.dirname(childDir);
          if (_path2.default.basename(parentDir) === 'features') {
            featureDir = parentDir;
            break;
          }
        }
        return _path2.default.relative(_this.cwd, featureDir);
      });
      return _lodash2.default.uniq(featureDirs);
    }
  }, {
    key: 'getFormatOptions',
    value: function getFormatOptions() {
      var formatOptions = _lodash2.default.clone(this.options.formatOptions);
      formatOptions.cwd = this.cwd;
      _lodash2.default.defaults(formatOptions, { colorsEnabled: true });
      return formatOptions;
    }
  }, {
    key: 'getFormats',
    value: function getFormats() {
      var mapping = { '': 'progress' };
      this.options.format.forEach(function (format) {
        var _OptionSplitter$split = _option_splitter2.default.split(format),
            _OptionSplitter$split2 = (0, _slicedToArray3.default)(_OptionSplitter$split, 2),
            type = _OptionSplitter$split2[0],
            outputTo = _OptionSplitter$split2[1];

        mapping[outputTo || ''] = type;
      });
      return _lodash2.default.map(mapping, function (type, outputTo) {
        return { outputTo: outputTo, type: type };
      });
    }
  }, {
    key: 'getUnexpandedFeaturePaths',
    value: function () {
      var _ref5 = (0, _bluebird.coroutine)(function* () {
        var _this2 = this;

        if (this.args.length > 0) {
          var nestedFeaturePaths = yield _bluebird2.default.map(this.args, function () {
            var _ref6 = (0, _bluebird.coroutine)(function* (arg) {
              var filename = _path2.default.basename(arg);
              if (filename[0] === '@') {
                var filePath = _path2.default.join(_this2.cwd, arg);
                var content = yield _fs2.default.readFile(filePath, 'utf8');
                return _lodash2.default.chain(content).split('\n').map(_lodash2.default.trim).compact().value();
              } else {
                return arg;
              }
            });

            return function (_x3) {
              return _ref6.apply(this, arguments);
            };
          }());
          var featurePaths = _lodash2.default.flatten(nestedFeaturePaths);
          if (featurePaths.length > 0) {
            return featurePaths;
          }
        }
        return ['features'];
      });

      function getUnexpandedFeaturePaths() {
        return _ref5.apply(this, arguments);
      }

      return getUnexpandedFeaturePaths;
    }()
  }, {
    key: 'expandSupportCodePaths',
    value: function () {
      var _ref7 = (0, _bluebird.coroutine)(function* (supportCodePaths) {
        var extensions = ['js'];
        this.options.compiler.forEach(function (compiler) {
          var _OptionSplitter$split3 = _option_splitter2.default.split(compiler),
              _OptionSplitter$split4 = (0, _slicedToArray3.default)(_OptionSplitter$split3, 2),
              extension = _OptionSplitter$split4[0],
              module = _OptionSplitter$split4[1];

          extensions.push(extension);
          require(module);
        });
        return yield this.pathExpander.expandPathsWithExtensions(supportCodePaths, extensions);
      });

      function expandSupportCodePaths(_x4) {
        return _ref7.apply(this, arguments);
      }

      return expandSupportCodePaths;
    }()
  }]);
  return ConfigurationBuilder;
}();

exports.default = ConfigurationBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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