'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _2 = require('./');

var _3 = _interopRequireDefault(_2);

var _status = require('../status');

var _status2 = _interopRequireDefault(_status);

var _helpers = require('./helpers');

var _step_arguments = require('../step_arguments');

var _assertionErrorFormatter = require('assertion-error-formatter');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getStepLineToKeywordMap = _helpers.GherkinDocumentParser.getStepLineToKeywordMap,
    getScenarioLineToDescriptionMap = _helpers.GherkinDocumentParser.getScenarioLineToDescriptionMap;
var getScenarioDescription = _helpers.PickleParser.getScenarioDescription,
    getStepLineToPickledStepMap = _helpers.PickleParser.getStepLineToPickledStepMap,
    getStepKeyword = _helpers.PickleParser.getStepKeyword;

var JsonFormatter = function (_Formatter) {
  (0, _inherits3.default)(JsonFormatter, _Formatter);

  function JsonFormatter(options) {
    (0, _classCallCheck3.default)(this, JsonFormatter);

    var _this = (0, _possibleConstructorReturn3.default)(this, (JsonFormatter.__proto__ || Object.getPrototypeOf(JsonFormatter)).call(this, options));

    options.eventBroadcaster.on('test-run-finished', _this.onTestRunFinished.bind(_this));
    return _this;
  }

  (0, _createClass3.default)(JsonFormatter, [{
    key: 'convertNameToId',
    value: function convertNameToId(obj) {
      return obj.name.replace(/ /g, '-').toLowerCase();
    }
  }, {
    key: 'formatDataTable',
    value: function formatDataTable(dataTable) {
      return {
        rows: dataTable.rows.map(function (row) {
          return { cells: _lodash2.default.map(row.cells, 'value') };
        })
      };
    }
  }, {
    key: 'formatDocString',
    value: function formatDocString(docString) {
      return {
        content: docString.content,
        line: docString.location.line
      };
    }
  }, {
    key: 'formatStepArguments',
    value: function formatStepArguments(stepArguments) {
      var iterator = (0, _step_arguments.buildStepArgumentIterator)({
        dataTable: this.formatDataTable.bind(this),
        docString: this.formatDocString.bind(this)
      });
      return _lodash2.default.map(stepArguments, iterator);
    }
  }, {
    key: 'onTestRunFinished',
    value: function onTestRunFinished() {
      var _this2 = this;

      var groupedTestCases = {};
      _lodash2.default.each(this.eventDataCollector.testCaseMap, function (testCase) {
        var uri = testCase.sourceLocation.uri;

        if (!groupedTestCases[uri]) {
          groupedTestCases[uri] = [];
        }
        groupedTestCases[uri].push(testCase);
      });
      var features = _lodash2.default.map(groupedTestCases, function (group, uri) {
        var gherkinDocument = _this2.eventDataCollector.gherkinDocumentMap[uri];
        var featureData = _this2.getFeatureData(gherkinDocument.feature, uri);
        var stepLineToKeywordMap = getStepLineToKeywordMap(gherkinDocument);
        var scenarioLineToDescriptionMap = getScenarioLineToDescriptionMap(gherkinDocument);
        featureData.elements = group.map(function (testCase) {
          var _eventDataCollector$g = _this2.eventDataCollector.getTestCaseData(testCase.sourceLocation),
              pickle = _eventDataCollector$g.pickle;

          var scenarioData = _this2.getScenarioData({
            featureId: featureData.id,
            pickle: pickle,
            scenarioLineToDescriptionMap: scenarioLineToDescriptionMap
          });
          var stepLineToPickledStepMap = getStepLineToPickledStepMap(pickle);
          var isBeforeHook = true;
          scenarioData.steps = testCase.steps.map(function (testStep) {
            isBeforeHook = isBeforeHook && !testStep.sourceLocation;
            return _this2.getStepData({
              isBeforeHook: isBeforeHook,
              stepLineToKeywordMap: stepLineToKeywordMap,
              stepLineToPickledStepMap: stepLineToPickledStepMap,
              testStep: testStep
            });
          });
          return scenarioData;
        });
        return featureData;
      });
      this.log(JSON.stringify(features, null, 2));
    }
  }, {
    key: 'getFeatureData',
    value: function getFeatureData(feature, uri) {
      return {
        description: feature.description,
        keyword: feature.keyword,
        name: feature.name,
        line: feature.location.line,
        id: this.convertNameToId(feature),
        tags: this.getTags(feature),
        uri: uri
      };
    }
  }, {
    key: 'getScenarioData',
    value: function getScenarioData(_ref) {
      var featureId = _ref.featureId,
          pickle = _ref.pickle,
          scenarioLineToDescriptionMap = _ref.scenarioLineToDescriptionMap;

      var description = getScenarioDescription({
        pickle: pickle,
        scenarioLineToDescriptionMap: scenarioLineToDescriptionMap
      });
      return {
        description: description,
        id: featureId + ';' + this.convertNameToId(pickle),
        keyword: 'Scenario',
        line: pickle.locations[0].line,
        name: pickle.name,
        tags: this.getTags(pickle),
        type: 'scenario'
      };
    }
  }, {
    key: 'getStepData',
    value: function getStepData(_ref2) {
      var isBeforeHook = _ref2.isBeforeHook,
          stepLineToKeywordMap = _ref2.stepLineToKeywordMap,
          stepLineToPickledStepMap = _ref2.stepLineToPickledStepMap,
          testStep = _ref2.testStep;

      var data = {};
      if (testStep.sourceLocation) {
        var line = testStep.sourceLocation.line;

        var pickleStep = stepLineToPickledStepMap[line];
        data.arguments = this.formatStepArguments(pickleStep.arguments);
        data.keyword = getStepKeyword({ pickleStep: pickleStep, stepLineToKeywordMap: stepLineToKeywordMap });
        data.line = line;
        data.name = pickleStep.text;
      } else {
        data.keyword = isBeforeHook ? 'Before' : 'After';
        data.hidden = true;
      }
      if (testStep.actionLocation) {
        data.match = { location: (0, _helpers.formatLocation)(testStep.actionLocation) };
      }
      if (testStep.result) {
        var _testStep$result = testStep.result,
            exception = _testStep$result.exception,
            status = _testStep$result.status;

        data.result = { status: status };
        if (testStep.result.duration) {
          data.result.duration = testStep.result.duration;
        }
        if (status === _status2.default.FAILED && exception) {
          data.result.error_message = (0, _assertionErrorFormatter.format)(exception);
        }
      }
      if (_lodash2.default.size(testStep.attachments) > 0) {
        data.embeddings = testStep.attachments.map(function (attachment) {
          return {
            data: attachment.data,
            mime_type: attachment.media.type
          };
        });
      }
      return data;
    }
  }, {
    key: 'getTags',
    value: function getTags(obj) {
      return _lodash2.default.map(obj.tags, function (tagData) {
        return { name: tagData.name, line: tagData.location.line };
      });
    }
  }]);
  return JsonFormatter;
}(_3.default);

exports.default = JsonFormatter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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