import AstNode from './AstNode';
import { messages, IdGenerator } from '@cucumber/messages';
import { RuleType } from './Parser';
import Token from './Token';
export default class AstBuilder {
    private stack;
    private comments;
    private readonly newId;
    constructor(newId: IdGenerator.NewId);
    reset(): void;
    startRule(ruleType: RuleType): void;
    endRule(): void;
    build(token: Token): void;
    getResult(): any;
    currentNode(): AstNode;
    getLocation(token: Token, column?: number): messages.ILocation;
    getTags(node: AstNode): messages.GherkinDocument.Feature.ITag[];
    getCells(tableRowToken: Token): messages.GherkinDocument.Feature.TableRow.TableCell[];
    getDescription(node: AstNode): any;
    getSteps(node: AstNode): any[];
    getTableRows(node: AstNode): messages.GherkinDocument.Feature.TableRow[];
    ensureCellCount(rows: messages.GherkinDocument.Feature.TableRow[]): void;
    transformNode(node: AstNode): string | AstNode | messages.GherkinDocument | messages.GherkinDocument.Feature | messages.GherkinDocument.Feature.Step | messages.GherkinDocument.Feature.Step.DocString | messages.GherkinDocument.Feature.Step.DataTable | messages.GherkinDocument.Feature.TableRow[] | messages.GherkinDocument.Feature.Background | messages.GherkinDocument.Feature.Scenario | messages.GherkinDocument.Feature.Scenario.Examples | messages.GherkinDocument.Feature.FeatureChild.Rule;
}
