"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var AstNode = /** @class */ (function () {
    function AstNode(ruleType) {
        this.ruleType = ruleType;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        this.subItems = new Map();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    AstNode.prototype.add = function (type, obj) {
        var items = this.subItems.get(type);
        if (items === undefined) {
            items = [];
            this.subItems.set(type, items);
        }
        items.push(obj);
    };
    AstNode.prototype.getSingle = function (ruleType) {
        return (this.subItems.get(ruleType) || [])[0];
    };
    AstNode.prototype.getItems = function (ruleType) {
        return this.subItems.get(ruleType) || [];
    };
    AstNode.prototype.getToken = function (tokenType) {
        return (this.subItems.get(tokenType) || [])[0];
    };
    AstNode.prototype.getTokens = function (tokenType) {
        return this.subItems.get(tokenType) || [];
    };
    return AstNode;
}());
exports.default = AstNode;
//# sourceMappingURL=AstNode.js.map