import { messages } from '@cucumber/messages';
import Token from './Token';
declare class GherkinException extends Error {
    errors: Error[];
    location: messages.ILocation;
    constructor(message: string);
    protected static _create<T>(location: messages.ILocation, message: string): GherkinException;
}
export declare class ParserException extends GherkinException {
    static create(message: string, line: number, column: number): ParserException;
}
export declare class CompositeParserException extends GherkinException {
    static create(errors: Error[]): CompositeParserException;
}
export declare class UnexpectedTokenException extends GherkinException {
    static create(token: Token, expectedTokenTypes: string[]): GherkinException;
}
export declare class UnexpectedEOFException extends GherkinException {
    static create(token: Token, expectedTokenTypes: string[]): GherkinException;
}
export declare class AstBuilderException extends GherkinException {
    static create(message: string, location: messages.ILocation): GherkinException;
}
export declare class NoSuchLanguageException extends GherkinException {
    static create(language: string, location: messages.ILocation): GherkinException;
}
export {};
