"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var createLocation_1 = __importDefault(require("./cli/createLocation"));
var GherkinException = /** @class */ (function (_super) {
    __extends(GherkinException, _super);
    function GherkinException(message) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, message) || this;
        var actualProto = _newTarget.prototype;
        // https://stackoverflow.com/questions/41102060/typescript-extending-error-class
        if (Object.setPrototypeOf) {
            Object.setPrototypeOf(_this, actualProto);
        }
        else {
            // @ts-ignore
            _this.__proto__ = actualProto;
        }
        return _this;
    }
    GherkinException._create = function (location, message) {
        var column = location.column || 0;
        var m = "(" + location.line + ":" + column + "): " + message;
        var err = new this(m);
        err.location = location;
        return err;
    };
    return GherkinException;
}(Error));
var ParserException = /** @class */ (function (_super) {
    __extends(ParserException, _super);
    function ParserException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ParserException.create = function (message, line, column) {
        var err = new this("(" + line + ":" + column + "): " + message);
        err.location = createLocation_1.default({ line: line, column: column });
        return err;
    };
    return ParserException;
}(GherkinException));
exports.ParserException = ParserException;
var CompositeParserException = /** @class */ (function (_super) {
    __extends(CompositeParserException, _super);
    function CompositeParserException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CompositeParserException.create = function (errors) {
        var message = 'Parser errors:\n' + errors.map(function (e) { return e.message; }).join('\n');
        var err = new this(message);
        err.errors = errors;
        return err;
    };
    return CompositeParserException;
}(GherkinException));
exports.CompositeParserException = CompositeParserException;
var UnexpectedTokenException = /** @class */ (function (_super) {
    __extends(UnexpectedTokenException, _super);
    function UnexpectedTokenException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnexpectedTokenException.create = function (token, expectedTokenTypes) {
        var message = "expected: " + expectedTokenTypes.join(', ') + ", got '" + token.getTokenValue().trim() + "'";
        var location = tokenLocation(token);
        return this._create(location, message);
    };
    return UnexpectedTokenException;
}(GherkinException));
exports.UnexpectedTokenException = UnexpectedTokenException;
var UnexpectedEOFException = /** @class */ (function (_super) {
    __extends(UnexpectedEOFException, _super);
    function UnexpectedEOFException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnexpectedEOFException.create = function (token, expectedTokenTypes) {
        var message = "unexpected end of file, expected: " + expectedTokenTypes.join(', ');
        var location = tokenLocation(token);
        return this._create(location, message);
    };
    return UnexpectedEOFException;
}(GherkinException));
exports.UnexpectedEOFException = UnexpectedEOFException;
var AstBuilderException = /** @class */ (function (_super) {
    __extends(AstBuilderException, _super);
    function AstBuilderException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AstBuilderException.create = function (message, location) {
        return this._create(location, message);
    };
    return AstBuilderException;
}(GherkinException));
exports.AstBuilderException = AstBuilderException;
var NoSuchLanguageException = /** @class */ (function (_super) {
    __extends(NoSuchLanguageException, _super);
    function NoSuchLanguageException() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NoSuchLanguageException.create = function (language, location) {
        var message = 'Language not supported: ' + language;
        return this._create(location, message);
    };
    return NoSuchLanguageException;
}(GherkinException));
exports.NoSuchLanguageException = NoSuchLanguageException;
function tokenLocation(token) {
    return token.location &&
        token.location.line &&
        token.line &&
        token.line.indent !== undefined
        ? createLocation_1.default({
            line: token.location.line,
            column: token.line.indent + 1,
        })
        : token.location;
}
//# sourceMappingURL=Errors.js.map