"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var stream_1 = require("stream");
var messages_1 = require("@cucumber/messages");
var ParserMessageStream_1 = __importDefault(require("./stream/ParserMessageStream"));
var SourceMessageStream_1 = __importDefault(require("./stream/SourceMessageStream"));
var gherkin_languages_json_1 = __importDefault(require("./gherkin-languages.json"));
var makeGherkinOptions_1 = __importDefault(require("./makeGherkinOptions"));
function fromStream(stream, options) {
    return stream_1.pipeline(stream, new messages_1.BinaryToMessageStream(messages_1.messages.Envelope.decodeDelimited), new ParserMessageStream_1.default(options));
}
function fromPaths(paths, options) {
    options = makeGherkinOptions_1.default(options);
    var combinedMessageStream = new stream_1.PassThrough({
        writableObjectMode: true,
        readableObjectMode: true,
    });
    function pipeSequentially() {
        var path = paths.shift();
        if (path !== undefined) {
            var parserMessageStream = new ParserMessageStream_1.default(options);
            parserMessageStream.on('end', function () {
                pipeSequentially();
            });
            var end = paths.length === 0;
            // Can't use pipeline here because of the { end } argument,
            // so we have to manually propagate errors.
            options
                .createReadStream(path)
                .on('error', function (err) { return combinedMessageStream.emit('error', err); })
                .pipe(new SourceMessageStream_1.default(path))
                .on('error', function (err) { return combinedMessageStream.emit('error', err); })
                .pipe(parserMessageStream)
                .on('error', function (err) { return combinedMessageStream.emit('error', err); })
                .pipe(combinedMessageStream, { end: end });
        }
    }
    pipeSequentially();
    return combinedMessageStream;
}
function fromSources(envelopes, options) {
    options = makeGherkinOptions_1.default(options);
    var combinedMessageStream = new stream_1.PassThrough({
        writableObjectMode: true,
        readableObjectMode: true,
    });
    function pipeSequentially() {
        var envelope = envelopes.shift();
        if (envelope !== undefined && envelope.source) {
            var parserMessageStream = new ParserMessageStream_1.default(options);
            parserMessageStream.pipe(combinedMessageStream, {
                end: envelopes.length === 0,
            });
            parserMessageStream.on('end', pipeSequentially);
            parserMessageStream.end(envelope);
        }
    }
    pipeSequentially();
    return combinedMessageStream;
}
function dialects() {
    return gherkin_languages_json_1.default;
}
exports.default = {
    fromPaths: fromPaths,
    fromStream: fromStream,
    fromSources: fromSources,
    dialects: dialects,
};
//# sourceMappingURL=Gherkin.js.map