"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var countSymbols_1 = __importDefault(require("./countSymbols"));
var Errors_1 = require("./Errors");
var GherkinLine = /** @class */ (function () {
    function GherkinLine(lineText, lineNumber) {
        this.lineText = lineText;
        this.lineNumber = lineNumber;
        this.trimmedLineText = lineText.replace(/^\s+/g, ''); // ltrim
        this.isEmpty = this.trimmedLineText.length === 0;
        this.indent = countSymbols_1.default(lineText) - countSymbols_1.default(this.trimmedLineText);
    }
    GherkinLine.prototype.startsWith = function (prefix) {
        return this.trimmedLineText.indexOf(prefix) === 0;
    };
    GherkinLine.prototype.startsWithTitleKeyword = function (keyword) {
        return this.startsWith(keyword + ':'); // The C# impl is more complicated. Find out why.
    };
    GherkinLine.prototype.getLineText = function (indentToRemove) {
        if (indentToRemove < 0 || indentToRemove > this.indent) {
            return this.trimmedLineText;
        }
        else {
            return this.lineText.substring(indentToRemove);
        }
    };
    GherkinLine.prototype.getRestTrimmed = function (length) {
        return this.trimmedLineText.substring(length).trim();
    };
    GherkinLine.prototype.getTableCells = function () {
        var cells = [];
        var col = 0;
        var startCol = col + 1;
        var cell = '';
        var firstCell = true;
        while (col < this.trimmedLineText.length) {
            var chr = this.trimmedLineText[col];
            col++;
            if (chr === '|') {
                if (firstCell) {
                    // First cell (content before the first |) is skipped
                    firstCell = false;
                }
                else {
                    // Keeps newlines
                    var trimmedLeft = cell.replace(/^[ \t\v\f\r\u0085\u00A0]*/g, '');
                    var trimmed = trimmedLeft.replace(/[ \t\v\f\r\u0085\u00A0]*$/g, '');
                    var cellIndent = cell.length - trimmedLeft.length;
                    var span = {
                        column: this.indent + startCol + cellIndent,
                        text: trimmed,
                    };
                    cells.push(span);
                }
                cell = '';
                startCol = col + 1;
            }
            else if (chr === '\\') {
                chr = this.trimmedLineText[col];
                col += 1;
                if (chr === 'n') {
                    cell += '\n';
                }
                else {
                    if (chr !== '|' && chr !== '\\') {
                        cell += '\\';
                    }
                    cell += chr;
                }
            }
            else {
                cell += chr;
            }
        }
        return cells;
    };
    GherkinLine.prototype.getTags = function () {
        var uncommentedLine = this.trimmedLineText.split(/\s#/g, 2)[0];
        var column = this.indent + 1;
        var items = uncommentedLine.split('@');
        var tags = [];
        for (var i = 0; i < items.length; i++) {
            var item = items[i].trimRight();
            if (item.length == 0) {
                continue;
            }
            if (!item.match(/^\S+$/)) {
                throw Errors_1.ParserException.create('A tag may not contain whitespace', this.lineNumber, column);
            }
            var span = { column: column, text: '@' + item };
            tags.push(span);
            column += countSymbols_1.default(items[i]) + 1;
        }
        return tags;
    };
    return GherkinLine;
}());
exports.default = GherkinLine;
module.exports = GherkinLine;
//# sourceMappingURL=GherkinLine.js.map