import { messages } from '@cucumber/messages';
export default class Query {
    private readonly gherkinDocuments;
    private readonly locationByAstNodeId;
    private readonly gherkinStepById;
    private readonly pickleIdsMapByUri;
    private readonly pickleStepIdsMapByUri;
    /**
     * Gets the location (line and column) of an AST node.
     * @param astNodeId
     */
    getLocation(astNodeId: string): messages.ILocation;
    getGherkinDocuments(): messages.IGherkinDocument[];
    /**
     * Gets all the pickle IDs
     * @param uri - the URI of the document
     * @param lineNumber - optionally restrict results to a particular line number
     */
    getPickleIds(uri: string, lineNumber?: number): string[];
    getPickleStepIds(uri: string, lineNumber: number): string[];
    update(message: messages.IEnvelope): Query;
    private updateGherkinBackground;
    private updateGherkinScenario;
    private updateGherkinStep;
    private updatePickle;
    private updatePickleSteps;
}
