"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var multimaps_1 = require("@teppeis/multimaps");
var Query = /** @class */ (function () {
    function Query() {
        this.gherkinDocuments = [];
        this.locationByAstNodeId = new Map();
        this.gherkinStepById = new Map();
        this.pickleIdsMapByUri = new Map();
        this.pickleStepIdsMapByUri = new Map();
    }
    /**
     * Gets the location (line and column) of an AST node.
     * @param astNodeId
     */
    Query.prototype.getLocation = function (astNodeId) {
        return this.locationByAstNodeId.get(astNodeId);
    };
    Query.prototype.getGherkinDocuments = function () {
        return this.gherkinDocuments;
    };
    /**
     * Gets all the pickle IDs
     * @param uri - the URI of the document
     * @param lineNumber - optionally restrict results to a particular line number
     */
    Query.prototype.getPickleIds = function (uri, lineNumber) {
        var pickleIdsByLineNumber = this.pickleIdsMapByUri.get(uri);
        return lineNumber === undefined
            ? Array.from(new Set(pickleIdsByLineNumber.values()))
            : pickleIdsByLineNumber.get(lineNumber);
    };
    Query.prototype.getPickleStepIds = function (uri, lineNumber) {
        var pickleStepIdsByLineNumber = this.pickleStepIdsMapByUri.get(uri);
        return pickleStepIdsByLineNumber.get(lineNumber);
    };
    Query.prototype.update = function (message) {
        var e_1, _a, e_2, _b;
        if (message.gherkinDocument) {
            this.gherkinDocuments.push(message.gherkinDocument);
            if (message.gherkinDocument.feature) {
                this.pickleIdsMapByUri.set(message.gherkinDocument.uri, new multimaps_1.ArrayMultimap());
                this.pickleStepIdsMapByUri.set(message.gherkinDocument.uri, new multimaps_1.ArrayMultimap());
                try {
                    for (var _c = __values(message.gherkinDocument.feature.children), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var featureChild = _d.value;
                        if (featureChild.background) {
                            this.updateGherkinBackground(featureChild.background);
                        }
                        if (featureChild.scenario) {
                            this.updateGherkinScenario(featureChild.scenario);
                        }
                        if (featureChild.rule) {
                            var ruleChildren = featureChild.rule.children;
                            try {
                                for (var ruleChildren_1 = (e_2 = void 0, __values(ruleChildren)), ruleChildren_1_1 = ruleChildren_1.next(); !ruleChildren_1_1.done; ruleChildren_1_1 = ruleChildren_1.next()) {
                                    var ruleChild = ruleChildren_1_1.value;
                                    if (ruleChild.background) {
                                        this.updateGherkinBackground(ruleChild.background);
                                    }
                                    if (ruleChild.scenario) {
                                        this.updateGherkinScenario(ruleChild.scenario);
                                    }
                                }
                            }
                            catch (e_2_1) { e_2 = { error: e_2_1 }; }
                            finally {
                                try {
                                    if (ruleChildren_1_1 && !ruleChildren_1_1.done && (_b = ruleChildren_1.return)) _b.call(ruleChildren_1);
                                }
                                finally { if (e_2) throw e_2.error; }
                            }
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
        }
        if (message.pickle) {
            var pickle = message.pickle;
            this.updatePickle(pickle);
        }
        return this;
    };
    Query.prototype.updateGherkinBackground = function (background) {
        var e_3, _a;
        try {
            for (var _b = __values(background.steps), _c = _b.next(); !_c.done; _c = _b.next()) {
                var step = _c.value;
                this.updateGherkinStep(step);
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
    };
    Query.prototype.updateGherkinScenario = function (scenario) {
        var e_4, _a, e_5, _b, e_6, _c;
        this.locationByAstNodeId.set(scenario.id, scenario.location);
        try {
            for (var _d = __values(scenario.steps), _e = _d.next(); !_e.done; _e = _d.next()) {
                var step = _e.value;
                this.updateGherkinStep(step);
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
            }
            finally { if (e_4) throw e_4.error; }
        }
        try {
            for (var _f = __values(scenario.examples), _g = _f.next(); !_g.done; _g = _f.next()) {
                var examples = _g.value;
                try {
                    for (var _h = (e_6 = void 0, __values(examples.tableBody)), _j = _h.next(); !_j.done; _j = _h.next()) {
                        var tableRow = _j.value;
                        this.locationByAstNodeId.set(tableRow.id, tableRow.location);
                    }
                }
                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                finally {
                    try {
                        if (_j && !_j.done && (_c = _h.return)) _c.call(_h);
                    }
                    finally { if (e_6) throw e_6.error; }
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
            }
            finally { if (e_5) throw e_5.error; }
        }
    };
    Query.prototype.updateGherkinStep = function (step) {
        this.locationByAstNodeId.set(step.id, step.location);
        this.gherkinStepById.set(step.id, step);
    };
    Query.prototype.updatePickle = function (pickle) {
        var e_7, _a;
        var _this = this;
        var pickleIdsByLineNumber = this.pickleIdsMapByUri.get(pickle.uri);
        var pickleLineNumbers = pickle.astNodeIds.map(function (astNodeId) { return _this.locationByAstNodeId.get(astNodeId).line; });
        try {
            for (var pickleLineNumbers_1 = __values(pickleLineNumbers), pickleLineNumbers_1_1 = pickleLineNumbers_1.next(); !pickleLineNumbers_1_1.done; pickleLineNumbers_1_1 = pickleLineNumbers_1.next()) {
                var pickleLineNumber = pickleLineNumbers_1_1.value;
                // if (!pickleIdsByLineNumber.has(pickleLineNumber)) {
                pickleIdsByLineNumber.put(pickleLineNumber, pickle.id);
                // }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (pickleLineNumbers_1_1 && !pickleLineNumbers_1_1.done && (_a = pickleLineNumbers_1.return)) _a.call(pickleLineNumbers_1);
            }
            finally { if (e_7) throw e_7.error; }
        }
        this.updatePickleSteps(pickle);
    };
    Query.prototype.updatePickleSteps = function (pickle) {
        var e_8, _a, e_9, _b;
        var _this = this;
        var pickleStepIdsByLineNumber = this.pickleStepIdsMapByUri.get(pickle.uri);
        var pickleSteps = pickle.steps;
        try {
            for (var pickleSteps_1 = __values(pickleSteps), pickleSteps_1_1 = pickleSteps_1.next(); !pickleSteps_1_1.done; pickleSteps_1_1 = pickleSteps_1.next()) {
                var pickleStep = pickleSteps_1_1.value;
                var stepLineNumbers = pickleStep.astNodeIds.map(function (astNodeId) { return _this.locationByAstNodeId.get(astNodeId).line; });
                try {
                    for (var stepLineNumbers_1 = (e_9 = void 0, __values(stepLineNumbers)), stepLineNumbers_1_1 = stepLineNumbers_1.next(); !stepLineNumbers_1_1.done; stepLineNumbers_1_1 = stepLineNumbers_1.next()) {
                        var stepLineNumber = stepLineNumbers_1_1.value;
                        pickleStepIdsByLineNumber.put(stepLineNumber, pickleStep.id);
                    }
                }
                catch (e_9_1) { e_9 = { error: e_9_1 }; }
                finally {
                    try {
                        if (stepLineNumbers_1_1 && !stepLineNumbers_1_1.done && (_b = stepLineNumbers_1.return)) _b.call(stepLineNumbers_1);
                    }
                    finally { if (e_9) throw e_9.error; }
                }
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (pickleSteps_1_1 && !pickleSteps_1_1.done && (_a = pickleSteps_1.return)) _a.call(pickleSteps_1);
            }
            finally { if (e_8) throw e_8.error; }
        }
    };
    return Query;
}());
exports.default = Query;
//# sourceMappingURL=Query.js.map