"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var Token_1 = __importDefault(require("./Token"));
var GherkinLine_1 = __importDefault(require("./GherkinLine"));
var createLocation_1 = __importDefault(require("./cli/createLocation"));
/**
 * The scanner reads a gherkin doc (typically read from a .feature file) and creates a token for each line.
 * The tokens are passed to the parser, which outputs an AST (Abstract Syntax Tree).
 *
 * If the scanner sees a `#` language header, it will reconfigure itself dynamically to look for
 * Gherkin keywords for the associated language. The keywords are defined in gherkin-languages.json.
 */
var TokenScanner = /** @class */ (function () {
    function TokenScanner(source) {
        this.lineNumber = 0;
        this.lines = source.split(/\r?\n/);
        if (this.lines.length > 0 &&
            this.lines[this.lines.length - 1].trim() === '') {
            this.lines.pop();
        }
    }
    TokenScanner.prototype.read = function () {
        var line = this.lines[this.lineNumber++];
        var location = createLocation_1.default({
            line: this.lineNumber,
        });
        location.column = undefined;
        return line == null
            ? new Token_1.default(null, location)
            : new Token_1.default(new GherkinLine_1.default(line, this.lineNumber), location);
    };
    return TokenScanner;
}());
exports.default = TokenScanner;
//# sourceMappingURL=TokenScanner.js.map