"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs_1 = __importDefault(require("fs"));
var commander_1 = require("commander");
var package_json_1 = __importDefault(require("../../package.json"));
var Gherkin_1 = __importDefault(require("../Gherkin"));
var messages_1 = require("@cucumber/messages");
var program = new commander_1.Command();
program.version(package_json_1.default.version);
program.option('--no-source', 'Do not output Source messages', false);
program.option('--no-ast', 'Do not output GherkinDocument messages', false);
program.option('--no-pickles', 'Do not output Pickle messages', false);
program.option('--predictable-ids', 'Use predictable ids', false);
program.option('-f, --format <format>', 'output format: ndjson|protobuf', 'protobuf');
program.parse(process.argv);
var paths = program.args;
var options = {
    defaultDialect: 'en',
    includeSource: program.source,
    includeGherkinDocument: program.ast,
    includePickles: program.pickles,
    newId: program.predictableIds
        ? messages_1.IdGenerator.incrementing()
        : messages_1.IdGenerator.uuid(),
    createReadStream: function (path) {
        return fs_1.default.createReadStream(path, { encoding: 'utf-8' });
    },
};
var messageStream = paths.length === 0
    ? Gherkin_1.default.fromStream(process.stdin, options)
    : Gherkin_1.default.fromPaths(paths, options);
var encodedStream;
switch (program.format) {
    case 'ndjson':
        encodedStream = new messages_1.MessageToNdjsonStream();
        break;
    case 'protobuf':
        encodedStream = new messages_1.MessageToBinaryStream();
        break;
    default:
        throw new Error("Unsupported format: " + program.format);
}
messageStream.pipe(encodedStream).pipe(process.stdout);
//# sourceMappingURL=main.js.map