"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var generateMessages_1 = __importDefault(require("./generateMessages"));
var stream_1 = require("stream");
/**
 * Stream that reads Source messages and writes GherkinDocument and Pickle messages.
 */
var ParserMessageStream = /** @class */ (function (_super) {
    __extends(ParserMessageStream, _super);
    function ParserMessageStream(options) {
        var _this = _super.call(this, { writableObjectMode: true, readableObjectMode: true }) || this;
        _this.options = options;
        return _this;
    }
    ParserMessageStream.prototype._transform = function (envelope, encoding, callback) {
        var e_1, _a;
        if (envelope.source) {
            var messageList = generateMessages_1.default(envelope.source.data, envelope.source.uri, this.options);
            try {
                for (var messageList_1 = __values(messageList), messageList_1_1 = messageList_1.next(); !messageList_1_1.done; messageList_1_1 = messageList_1.next()) {
                    var message = messageList_1_1.value;
                    this.push(message);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (messageList_1_1 && !messageList_1_1.done && (_a = messageList_1.return)) _a.call(messageList_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        callback();
    };
    return ParserMessageStream;
}(stream_1.Transform));
exports.default = ParserMessageStream;
module.exports = ParserMessageStream;
//# sourceMappingURL=ParserMessageStream.js.map