"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var stream_1 = require("stream");
var makeSourceEnvelope_1 = __importDefault(require("./makeSourceEnvelope"));
/**
 * Stream that reads a string and writes a single Source message.
 */
var SourceMessageStream = /** @class */ (function (_super) {
    __extends(SourceMessageStream, _super);
    function SourceMessageStream(uri) {
        var _this = _super.call(this, { readableObjectMode: true, writableObjectMode: false }) || this;
        _this.uri = uri;
        _this.buffer = Buffer.alloc(0);
        return _this;
    }
    SourceMessageStream.prototype._transform = function (chunk, encoding, callback) {
        this.buffer = Buffer.concat([this.buffer, chunk]);
        callback();
    };
    SourceMessageStream.prototype._flush = function (callback) {
        var data = this.buffer.toString('UTF-8');
        var chunk = makeSourceEnvelope_1.default(data, this.uri);
        this.push(chunk);
        callback();
    };
    return SourceMessageStream;
}(stream_1.Transform));
exports.default = SourceMessageStream;
//# sourceMappingURL=SourceMessageStream.js.map