"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var Parser_1 = __importDefault(require("../Parser"));
var TokenMatcher_1 = __importDefault(require("../TokenMatcher"));
var messages_1 = require("@cucumber/messages");
var compile_1 = __importDefault(require("../pickles/compile"));
var AstBuilder_1 = __importDefault(require("../AstBuilder"));
function generateMessages(data, uri, options) {
    var e_1, _a, e_2, _b;
    var result = [];
    try {
        if (options.includeSource) {
            result.push(new messages_1.messages.Envelope({
                source: {
                    uri: uri,
                    data: data,
                    mediaType: 'text/x.cucumber.gherkin+plain',
                },
            }));
        }
        if (!options.includeGherkinDocument && !options.includePickles) {
            return result;
        }
        var parser = new Parser_1.default(new AstBuilder_1.default(options.newId));
        parser.stopAtFirstError = false;
        var gherkinDocument = parser.parse(data, new TokenMatcher_1.default(options.defaultDialect));
        if (options.includeGherkinDocument) {
            result.push(messages_1.messages.Envelope.create({
                gherkinDocument: __assign(__assign({}, gherkinDocument), { uri: uri }),
            }));
        }
        if (options.includePickles) {
            var pickles = compile_1.default(gherkinDocument, uri, options.newId);
            try {
                for (var pickles_1 = __values(pickles), pickles_1_1 = pickles_1.next(); !pickles_1_1.done; pickles_1_1 = pickles_1.next()) {
                    var pickle = pickles_1_1.value;
                    result.push(messages_1.messages.Envelope.create({
                        pickle: pickle,
                    }));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (pickles_1_1 && !pickles_1_1.done && (_a = pickles_1.return)) _a.call(pickles_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    }
    catch (err) {
        var errors = err.errors || [err];
        try {
            for (var errors_1 = __values(errors), errors_1_1 = errors_1.next(); !errors_1_1.done; errors_1_1 = errors_1.next()) {
                var error = errors_1_1.value;
                if (!error.location) {
                    // It wasn't a parser error - throw it (this is unexpected)
                    throw error;
                }
                result.push(messages_1.messages.Envelope.create({
                    attachment: {
                        source: {
                            uri: uri,
                            location: {
                                line: error.location.line,
                                column: error.location.column,
                            },
                        },
                        text: error.message,
                    },
                }));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (errors_1_1 && !errors_1_1.done && (_b = errors_1.return)) _b.call(errors_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    return result;
}
exports.default = generateMessages;
//# sourceMappingURL=generateMessages.js.map