import { messages } from '@cucumber/messages';
export default class Query {
    private readonly testStepResultByPickleId;
    private readonly testStepResultsByPickleStepId;
    private readonly testStepById;
    private readonly pickleIdByTestStepId;
    private readonly pickleStepIdByTestStepId;
    private readonly attachmentsByPickleStepId;
    private readonly stepMatchArgumentsListsByPickleStepId;
    update(envelope: messages.IEnvelope): void;
    /**
     * Gets all the results for multiple pickle steps
     * @param pickleStepIds
     */
    getPickleStepTestStepResults(pickleStepIds: string[]): messages.ITestStepResult[];
    /**
     * Gets all the results for multiple pickles
     * @param pickleIds
     */
    getPickleTestStepResults(pickleIds: string[]): messages.ITestStepResult[];
    /**
     * Gets the worst result
     * @param testStepResults
     */
    getWorstTestStepResult(testStepResults: messages.ITestStepResult[]): messages.ITestStepResult;
    /**
     * Gets all the attachments for multiple pickle steps
     * @param pickleStepIds
     */
    getPickleStepAttachments(pickleStepIds: string[]): messages.IAttachment[];
    /**
     * Get StepMatchArguments for a pickle step
     * @param pickleStepId
     */
    getStepMatchArgumentsLists(pickleStepId: string): messages.TestCase.TestStep.IStepMatchArgumentsList[] | undefined;
}
