"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var messages_1 = require("@cucumber/messages");
var multimaps_1 = require("@teppeis/multimaps");
var Query = /** @class */ (function () {
    function Query() {
        this.testStepResultByPickleId = new multimaps_1.ArrayMultimap();
        this.testStepResultsByPickleStepId = new multimaps_1.ArrayMultimap();
        this.testStepById = new Map();
        this.pickleIdByTestStepId = new Map();
        this.pickleStepIdByTestStepId = new Map();
        this.attachmentsByPickleStepId = new multimaps_1.ArrayMultimap();
        this.stepMatchArgumentsListsByPickleStepId = new Map();
    }
    Query.prototype.update = function (envelope) {
        var e_1, _a;
        if (envelope.testCase) {
            try {
                for (var _b = __values(envelope.testCase.testSteps), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var testStep = _c.value;
                    this.testStepById.set(testStep.id, testStep);
                    this.pickleIdByTestStepId.set(testStep.id, envelope.testCase.pickleId);
                    this.pickleStepIdByTestStepId.set(testStep.id, testStep.pickleStepId);
                    this.stepMatchArgumentsListsByPickleStepId.set(testStep.pickleStepId, testStep.stepMatchArgumentsLists);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        if (envelope.testStepFinished) {
            var pickleId = this.pickleIdByTestStepId.get(envelope.testStepFinished.testStepId);
            this.testStepResultByPickleId.put(pickleId, envelope.testStepFinished.testStepResult);
            var testStep = this.testStepById.get(envelope.testStepFinished.testStepId);
            this.testStepResultsByPickleStepId.put(testStep.pickleStepId, envelope.testStepFinished.testStepResult);
        }
        if (envelope.attachment) {
            var pickleStepId = this.pickleStepIdByTestStepId.get(envelope.attachment.testStepId);
            this.attachmentsByPickleStepId.put(pickleStepId, envelope.attachment);
        }
    };
    /**
     * Gets all the results for multiple pickle steps
     * @param pickleStepIds
     */
    Query.prototype.getPickleStepTestStepResults = function (pickleStepIds) {
        var _this = this;
        if (pickleStepIds.length === 0) {
            return [
                new messages_1.messages.TestStepResult({
                    status: messages_1.messages.TestStepResult.Status.UNKNOWN,
                    duration: messages_1.TimeConversion.millisecondsToDuration(0),
                }),
            ];
        }
        return pickleStepIds.reduce(function (testStepResults, pickleId) {
            return testStepResults.concat(_this.testStepResultsByPickleStepId.get(pickleId));
        }, []);
    };
    /**
     * Gets all the results for multiple pickles
     * @param pickleIds
     */
    Query.prototype.getPickleTestStepResults = function (pickleIds) {
        var _this = this;
        if (pickleIds.length === 0) {
            return [
                new messages_1.messages.TestStepResult({
                    status: messages_1.messages.TestStepResult.Status.UNKNOWN,
                    duration: messages_1.TimeConversion.millisecondsToDuration(0),
                }),
            ];
        }
        return pickleIds.reduce(function (testStepResults, pickleId) {
            return testStepResults.concat(_this.testStepResultByPickleId.get(pickleId));
        }, []);
    };
    /**
     * Gets the worst result
     * @param testStepResults
     */
    Query.prototype.getWorstTestStepResult = function (testStepResults) {
        return (testStepResults.sort(function (r1, r2) { return r2.status - r1.status; })[0] ||
            new messages_1.messages.TestStepResult({
                status: messages_1.messages.TestStepResult.Status.UNKNOWN,
                duration: messages_1.TimeConversion.millisecondsToDuration(0),
            }));
    };
    /**
     * Gets all the attachments for multiple pickle steps
     * @param pickleStepIds
     */
    Query.prototype.getPickleStepAttachments = function (pickleStepIds) {
        var _this = this;
        return pickleStepIds.reduce(function (attachments, pickleStepId) {
            return attachments.concat(_this.attachmentsByPickleStepId.get(pickleStepId));
        }, []);
    };
    /**
     * Get StepMatchArguments for a pickle step
     * @param pickleStepId
     */
    Query.prototype.getStepMatchArgumentsLists = function (pickleStepId) {
        return this.stepMatchArgumentsListsByPickleStepId.get(pickleStepId);
    };
    return Query;
}());
exports.default = Query;
//# sourceMappingURL=Query.js.map