"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require("source-map-support/register");
var gherkin_1 = __importStar(require("@cucumber/gherkin"));
var messages_1 = require("@cucumber/messages");
var stream_1 = require("stream");
var assert_1 = __importDefault(require("assert"));
var SupportCode_1 = __importDefault(require("@cucumber/fake-cucumber/dist/src/SupportCode"));
var CucumberStream_1 = __importDefault(require("@cucumber/fake-cucumber/dist/src/CucumberStream"));
var ErrorMessageGenerator_1 = require("@cucumber/fake-cucumber/dist/src/ErrorMessageGenerator");
var util_1 = require("util");
var IncrementClock_1 = __importDefault(require("@cucumber/fake-cucumber/dist/src/IncrementClock"));
var Query_1 = __importDefault(require("../src/Query"));
var pipelinePromise = util_1.promisify(stream_1.pipeline);
describe('Query', function () {
    var gherkinQuery;
    var cucumberQuery;
    beforeEach(function () {
        gherkinQuery = new gherkin_1.Query();
        cucumberQuery = new Query_1.default();
    });
    describe('#getWorstTestStepResult(testStepResults)', function () {
        it('returns a FAILED result for PASSED,FAILED,PASSED', function () {
            var result = cucumberQuery.getWorstTestStepResult([
                new messages_1.messages.TestStepResult({
                    status: messages_1.messages.TestStepResult.Status.PASSED,
                }),
                new messages_1.messages.TestStepResult({
                    status: messages_1.messages.TestStepResult.Status.FAILED,
                }),
                new messages_1.messages.TestStepResult({
                    status: messages_1.messages.TestStepResult.Status.PASSED,
                }),
            ]);
            assert_1.default.strictEqual(result.status, messages_1.messages.TestStepResult.Status.FAILED);
        });
    });
    describe('#getPickleStepTestStepResults(pickleStepIds)', function () {
        it('returns a single UNKNOWN when the list is empty', function () {
            var results = cucumberQuery.getPickleTestStepResults([]);
            assert_1.default.deepStrictEqual(results.map(function (r) { return r.status; }), [messages_1.messages.TestStepResult.Status.UNKNOWN]);
        });
        it('looks up results for scenario steps', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleStepIds, testStepResults;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: ok\n    Given a passed step\n")];
                    case 1:
                        _a.sent();
                        pickleStepIds = gherkinQuery.getPickleStepIds('test.feature', 3);
                        assert_1.default.strictEqual(pickleStepIds.length, 1);
                        testStepResults = cucumberQuery.getPickleStepTestStepResults(pickleStepIds);
                        assert_1.default.strictEqual(testStepResults.length, 1);
                        assert_1.default.strictEqual(testStepResults[0].status, messages_1.messages.TestStepResult.Status.PASSED);
                        return [2 /*return*/];
                }
            });
        }); });
        it('looks up results for background steps', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleStepIds, testStepResults;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Background:\n    Given a passed step\n\n  Scenario: ok\n    Given a passed step\n\n  Scenario: ko\n    Given a failed step\n")];
                    case 1:
                        _a.sent();
                        pickleStepIds = gherkinQuery.getPickleStepIds('test.feature', 3);
                        assert_1.default.strictEqual(pickleStepIds.length, 2);
                        testStepResults = cucumberQuery.getPickleStepTestStepResults(pickleStepIds);
                        assert_1.default.deepStrictEqual(testStepResults.map(function (r) { return r.status; }), [
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.PASSED,
                        ]);
                        return [2 /*return*/];
                }
            });
        }); });
        it('looks up results for background steps when scenarios are empty', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleStepIds, testStepResults;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Background:\n    Given a passed step\n\n  Scenario: ok\n\n  Scenario: ok too\n")];
                    case 1:
                        _a.sent();
                        pickleStepIds = gherkinQuery.getPickleStepIds('test.feature', 3);
                        assert_1.default.strictEqual(pickleStepIds.length, 0);
                        testStepResults = cucumberQuery.getPickleStepTestStepResults(pickleStepIds);
                        assert_1.default.strictEqual(testStepResults.length, 1);
                        assert_1.default.strictEqual(testStepResults[0].status, messages_1.messages.TestStepResult.Status.UNKNOWN);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('#getPickleTestStepResults(pickleIds)', function () {
        it('looks up results for scenarios', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleIds, testStepResults;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: ko\n    Given a passed step\n    Given a failed step\n")];
                    case 1:
                        _a.sent();
                        pickleIds = gherkinQuery.getPickleIds('test.feature', 2);
                        assert_1.default.strictEqual(pickleIds.length, 1);
                        testStepResults = cucumberQuery.getPickleTestStepResults(pickleIds);
                        assert_1.default.deepStrictEqual(testStepResults.map(function (r) { return r.status; }), [
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.FAILED,
                        ]);
                        return [2 /*return*/];
                }
            });
        }); });
        it('looks up results for scenario outlines', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleIds;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: hi <status1> and <status2>\n    Given a <status1> step\n    And a <status2> step\n\n    Examples:\n      | status1    | status2 |\n      | passed     | passed  |\n      | passed     | failed  |\n")];
                    case 1:
                        _a.sent();
                        pickleIds = gherkinQuery.getPickleIds('test.feature', 2);
                        assert_1.default.strictEqual(pickleIds.length, 2);
                        assert_1.default.deepStrictEqual(cucumberQuery.getPickleTestStepResults(pickleIds).map(function (r) { return r.status; }), [
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.FAILED,
                        ]);
                        return [2 /*return*/];
                }
            });
        }); });
        it('looks up results for examples rows outlines', function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: hi <status1> and <status2>\n    Given a <status1> step\n    And a <status2> step\n\n    Examples:\n      | status1    | status2 |\n      | passed     | passed  |\n      | passed     | failed  |\n")];
                    case 1:
                        _a.sent();
                        assert_1.default.deepStrictEqual(cucumberQuery
                            .getPickleTestStepResults(gherkinQuery.getPickleIds('test.feature', 8))
                            .map(function (r) { return r.status; }), [
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.PASSED,
                        ]);
                        assert_1.default.deepStrictEqual(cucumberQuery
                            .getPickleTestStepResults(gherkinQuery.getPickleIds('test.feature', 9))
                            .map(function (r) { return r.status; }), [
                            messages_1.messages.TestStepResult.Status.PASSED,
                            messages_1.messages.TestStepResult.Status.FAILED,
                        ]);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('#getPickleStepAttachments(pickleIds)', function () {
        it('looks up attachments', function () { return __awaiter(void 0, void 0, void 0, function () {
            var pickleStepIds, attachments;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: ok\n    Given a passed step with attachment\n")];
                    case 1:
                        _a.sent();
                        pickleStepIds = gherkinQuery.getPickleStepIds('test.feature', 3);
                        assert_1.default.strictEqual(pickleStepIds.length, 1);
                        attachments = cucumberQuery.getPickleStepAttachments(pickleStepIds);
                        assert_1.default.strictEqual(attachments.length, 1);
                        assert_1.default.strictEqual(attachments[0].text, 'Hello');
                        return [2 /*return*/];
                }
            });
        }); });
    });
    describe('#getStepMatchArguments(uri, lineNumber)', function () {
        it("looks up result for step's uri and line", function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, parse("Feature: hello\n  Scenario: hi\n    Given a passed step\n    And I have 567 cukes in my belly\n")];
                    case 1:
                        _a.sent();
                        assert_1.default.deepStrictEqual(cucumberQuery
                            .getStepMatchArgumentsLists(gherkinQuery.getPickleStepIds('test.feature', 3)[0])
                            .map(function (sal) { return sal.stepMatchArguments.map(function (arg) { return arg.parameterTypeName; }); }), [[]]);
                        assert_1.default.deepStrictEqual(cucumberQuery
                            .getStepMatchArgumentsLists(gherkinQuery.getPickleStepIds('test.feature', 4)[0])
                            .map(function (sal) { return sal.stepMatchArguments.map(function (arg) { return arg.parameterTypeName; }); }), [['int', 'word']]);
                        return [2 /*return*/];
                }
            });
        }); });
    });
    function parse(gherkinSource) {
        var newId = messages_1.IdGenerator.incrementing();
        var clock = new IncrementClock_1.default();
        var makeErrorMessage = ErrorMessageGenerator_1.withFullStackTrace();
        var supportCode = new SupportCode_1.default(newId, clock, makeErrorMessage);
        supportCode.Given('a passed step', function () {
            // no-op
        });
        supportCode.Given('a passed step with attachment', function () {
            this.attach('Hello', 'text/plain');
        });
        supportCode.Given('a failed step', function () {
            throw new Error("This step failed.");
        });
        supportCode.Given('I have {int} cukes in my {word}', function (cukes) {
            assert_1.default.ok(cukes);
        });
        var cucumberStream = new CucumberStream_1.default(supportCode.parameterTypes, supportCode.stepDefinitions, supportCode.undefinedParameterTypes, supportCode.beforeHooks, supportCode.afterHooks, supportCode.newId, supportCode.clock, supportCode.makeErrorMessage);
        var queryUpdateStream = new stream_1.Writable({
            objectMode: true,
            write: function (envelope, encoding, callback) {
                try {
                    gherkinQuery.update(envelope);
                    cucumberQuery.update(envelope);
                    callback();
                }
                catch (err) {
                    callback(err);
                }
            },
        });
        return pipelinePromise(gherkinMessages(gherkinSource, 'test.feature', newId), cucumberStream, queryUpdateStream);
    }
    function gherkinMessages(gherkinSource, uri, newId) {
        var source = messages_1.messages.Envelope.fromObject({
            source: {
                uri: uri,
                data: gherkinSource,
                mediaType: 'text/x.cucumber.gherkin+plain',
            },
        });
        return gherkin_1.default.fromSources([source], { newId: newId });
    }
});
//# sourceMappingURL=QueryTest.js.map