import { SourceLocation } from "./SourceLocation.js";
import { ASTCursor } from "./ASTCursor.js";
import { ASTVisitor } from "./ASTVisitor.js";
import { ASTKind } from "./ASTKind.js";
import { Parser } from "./Parser.js";
import { Token } from "./Token.js";
export declare abstract class AST {
    private readonly handle;
    private readonly kind;
    protected readonly parser: Parser;
    constructor(handle: number, kind: ASTKind, parser: Parser);
    walk(): ASTCursor;
    getKind(): ASTKind;
    is(kind: ASTKind): boolean;
    isNot(kind: ASTKind): boolean;
    getHandle(): number;
    getStartLocation(): SourceLocation;
    getEndLocation(): SourceLocation;
    abstract accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    static from<T extends AST = AST>(handle: number, parser: Parser): T | undefined;
}
export declare abstract class AttributeAST extends AST {
}
export declare abstract class CoreDeclaratorAST extends AST {
}
export declare abstract class DeclarationAST extends AST {
}
export declare abstract class DeclaratorModifierAST extends AST {
}
export declare abstract class ExceptionDeclarationAST extends AST {
}
export declare abstract class ExpressionAST extends AST {
}
export declare abstract class FunctionBodyAST extends AST {
}
export declare abstract class InitializerAST extends AST {
}
export declare abstract class LambdaCaptureAST extends AST {
}
export declare abstract class MemInitializerAST extends AST {
}
export declare abstract class NameAST extends AST {
}
export declare abstract class NewInitializerAST extends AST {
}
export declare abstract class PtrOperatorAST extends AST {
}
export declare abstract class RequirementAST extends AST {
}
export declare abstract class SpecifierAST extends AST {
}
export declare abstract class StatementAST extends AST {
}
export declare abstract class TemplateArgumentAST extends AST {
}
export declare abstract class UnitAST extends AST {
}
export declare class TypeIdAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeSpecifierList(): Generator<SpecifierAST | undefined>;
    getDeclarator(): DeclaratorAST | undefined;
}
export declare class NestedNameSpecifierAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getScopeToken(): Token | undefined;
    getNameList(): Generator<NameAST | undefined>;
}
export declare class UsingDeclaratorAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypenameToken(): Token | undefined;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
}
export declare class HandlerAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCatchToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExceptionDeclaration(): ExceptionDeclarationAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): CompoundStatementAST | undefined;
}
export declare class EnumBaseAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getColonToken(): Token | undefined;
    getTypeSpecifierList(): Generator<SpecifierAST | undefined>;
}
export declare class EnumeratorAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getName(): NameAST | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getEqualToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class DeclaratorAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getPtrOpList(): Generator<PtrOperatorAST | undefined>;
    getCoreDeclarator(): CoreDeclaratorAST | undefined;
    getModifiers(): Generator<DeclaratorModifierAST | undefined>;
}
export declare class InitDeclaratorAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDeclarator(): DeclaratorAST | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
    getInitializer(): InitializerAST | undefined;
}
export declare class BaseSpecifierAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getName(): NameAST | undefined;
}
export declare class BaseClauseAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getColonToken(): Token | undefined;
    getBaseSpecifierList(): Generator<BaseSpecifierAST | undefined>;
}
export declare class NewTypeIdAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeSpecifierList(): Generator<SpecifierAST | undefined>;
}
export declare class RequiresClauseAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getRequiresToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class ParameterDeclarationClauseAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getParameterDeclarationList(): Generator<ParameterDeclarationAST | undefined>;
    getCommaToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
}
export declare class ParametersAndQualifiersAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getParameterDeclarationClause(): ParameterDeclarationClauseAST | undefined;
    getRparenToken(): Token | undefined;
    getCvQualifierList(): Generator<SpecifierAST | undefined>;
    getRefToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
}
export declare class LambdaIntroducerAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbracketToken(): Token | undefined;
    getCaptureDefaultToken(): Token | undefined;
    getCaptureList(): Generator<LambdaCaptureAST | undefined>;
    getRbracketToken(): Token | undefined;
}
export declare class LambdaDeclaratorAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getParameterDeclarationClause(): ParameterDeclarationClauseAST | undefined;
    getRparenToken(): Token | undefined;
    getDeclSpecifierList(): Generator<SpecifierAST | undefined>;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getTrailingReturnType(): TrailingReturnTypeAST | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
}
export declare class TrailingReturnTypeAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getMinusGreaterToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
}
export declare class CtorInitializerAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getColonToken(): Token | undefined;
    getMemInitializerList(): Generator<MemInitializerAST | undefined>;
}
export declare class RequirementBodyAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbraceToken(): Token | undefined;
    getRequirementList(): Generator<RequirementAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class TypeConstraintAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
}
export declare class GlobalModuleFragmentAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getModuleToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
}
export declare class PrivateModuleFragmentAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getModuleToken(): Token | undefined;
    getColonToken(): Token | undefined;
    getPrivateToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
}
export declare class ModuleDeclarationAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExportToken(): Token | undefined;
    getModuleToken(): Token | undefined;
    getModuleName(): ModuleNameAST | undefined;
    getModulePartition(): ModulePartitionAST | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getSemicolonToken(): Token | undefined;
}
export declare class ModuleNameAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class ImportNameAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getHeaderToken(): Token | undefined;
    getModulePartition(): ModulePartitionAST | undefined;
    getModuleName(): ModuleNameAST | undefined;
}
export declare class ModulePartitionAST extends AST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getColonToken(): Token | undefined;
    getModuleName(): ModuleNameAST | undefined;
}
export declare class SimpleRequirementAST extends RequirementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class CompoundRequirementAST extends RequirementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbraceToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRbraceToken(): Token | undefined;
    getNoexceptToken(): Token | undefined;
    getMinusGreaterToken(): Token | undefined;
    getTypeConstraint(): TypeConstraintAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class TypeRequirementAST extends RequirementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypenameToken(): Token | undefined;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class NestedRequirementAST extends RequirementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getRequiresToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class TypeTemplateArgumentAST extends TemplateArgumentAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeId(): TypeIdAST | undefined;
}
export declare class ExpressionTemplateArgumentAST extends TemplateArgumentAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExpression(): ExpressionAST | undefined;
}
export declare class ParenMemInitializerAST extends MemInitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getName(): NameAST | undefined;
    getLparenToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getRparenToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
}
export declare class BracedMemInitializerAST extends MemInitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getName(): NameAST | undefined;
    getBracedInitList(): BracedInitListAST | undefined;
    getEllipsisToken(): Token | undefined;
}
export declare class ThisLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getThisToken(): Token | undefined;
}
export declare class DerefThisLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getStarToken(): Token | undefined;
    getThisToken(): Token | undefined;
}
export declare class SimpleLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getIdentifierToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
}
export declare class RefLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAmpToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
}
export declare class RefInitLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAmpToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getInitializer(): InitializerAST | undefined;
}
export declare class InitLambdaCaptureAST extends LambdaCaptureAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEllipsisToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getInitializer(): InitializerAST | undefined;
}
export declare class EqualInitializerAST extends InitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEqualToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class BracedInitListAST extends InitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbraceToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getCommaToken(): Token | undefined;
    getRbraceToken(): Token | undefined;
}
export declare class ParenInitializerAST extends InitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getRparenToken(): Token | undefined;
}
export declare class NewParenInitializerAST extends NewInitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getRparenToken(): Token | undefined;
}
export declare class NewBracedInitializerAST extends NewInitializerAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBracedInit(): BracedInitListAST | undefined;
}
export declare class EllipsisExceptionDeclarationAST extends ExceptionDeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEllipsisToken(): Token | undefined;
}
export declare class TypeExceptionDeclarationAST extends ExceptionDeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getTypeSpecifierList(): Generator<SpecifierAST | undefined>;
    getDeclarator(): DeclaratorAST | undefined;
}
export declare class DefaultFunctionBodyAST extends FunctionBodyAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEqualToken(): Token | undefined;
    getDefaultToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class CompoundStatementFunctionBodyAST extends FunctionBodyAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCtorInitializer(): CtorInitializerAST | undefined;
    getStatement(): CompoundStatementAST | undefined;
}
export declare class TryStatementFunctionBodyAST extends FunctionBodyAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTryToken(): Token | undefined;
    getCtorInitializer(): CtorInitializerAST | undefined;
    getStatement(): CompoundStatementAST | undefined;
    getHandlerList(): Generator<HandlerAST | undefined>;
}
export declare class DeleteFunctionBodyAST extends FunctionBodyAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEqualToken(): Token | undefined;
    getDeleteToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class TranslationUnitAST extends UnitAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
}
export declare class ModuleUnitAST extends UnitAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getGlobalModuleFragment(): GlobalModuleFragmentAST | undefined;
    getModuleDeclaration(): ModuleDeclarationAST | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
    getPrivateModuleFragmentAST(): PrivateModuleFragmentAST | undefined;
}
export declare class ThisExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getThisToken(): Token | undefined;
}
export declare class CharLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class BoolLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class IntLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class FloatLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class NullptrLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class StringLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class UserDefinedStringLiteralExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLiteralToken(): Token | undefined;
}
export declare class IdExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getName(): NameAST | undefined;
}
export declare class RequiresExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getRequiresToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getParameterDeclarationClause(): ParameterDeclarationClauseAST | undefined;
    getRparenToken(): Token | undefined;
    getRequirementBody(): RequirementBodyAST | undefined;
}
export declare class NestedExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class RightFoldExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getOpToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getRparenToken(): Token | undefined;
}
export declare class LeftFoldExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getOpToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class FoldExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getLeftExpression(): ExpressionAST | undefined;
    getOpToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getFoldOpToken(): Token | undefined;
    getRightExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class LambdaExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLambdaIntroducer(): LambdaIntroducerAST | undefined;
    getLessToken(): Token | undefined;
    getTemplateParameterList(): Generator<DeclarationAST | undefined>;
    getGreaterToken(): Token | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
    getLambdaDeclarator(): LambdaDeclaratorAST | undefined;
    getStatement(): CompoundStatementAST | undefined;
}
export declare class SizeofExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSizeofToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class SizeofTypeExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSizeofToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class SizeofPackExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSizeofToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getRparenToken(): Token | undefined;
}
export declare class TypeidExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeidToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class TypeidOfTypeExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeidToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class AlignofExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAlignofToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class TypeTraitsExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeTraitsToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getTypeIdList(): Generator<TypeIdAST | undefined>;
    getRparenToken(): Token | undefined;
}
export declare class UnaryExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getOpToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class BinaryExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLeftExpression(): ExpressionAST | undefined;
    getOpToken(): Token | undefined;
    getRightExpression(): ExpressionAST | undefined;
}
export declare class AssignmentExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLeftExpression(): ExpressionAST | undefined;
    getOpToken(): Token | undefined;
    getRightExpression(): ExpressionAST | undefined;
}
export declare class BracedTypeConstructionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeSpecifier(): SpecifierAST | undefined;
    getBracedInitList(): BracedInitListAST | undefined;
}
export declare class TypeConstructionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeSpecifier(): SpecifierAST | undefined;
    getLparenToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getRparenToken(): Token | undefined;
}
export declare class CallExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBaseExpression(): ExpressionAST | undefined;
    getLparenToken(): Token | undefined;
    getExpressionList(): Generator<ExpressionAST | undefined>;
    getRparenToken(): Token | undefined;
}
export declare class SubscriptExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBaseExpression(): ExpressionAST | undefined;
    getLbracketToken(): Token | undefined;
    getIndexExpression(): ExpressionAST | undefined;
    getRbracketToken(): Token | undefined;
}
export declare class MemberExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBaseExpression(): ExpressionAST | undefined;
    getAccessToken(): Token | undefined;
    getTemplateToken(): Token | undefined;
    getName(): NameAST | undefined;
}
export declare class PostIncrExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBaseExpression(): ExpressionAST | undefined;
    getOpToken(): Token | undefined;
}
export declare class ConditionalExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCondition(): ExpressionAST | undefined;
    getQuestionToken(): Token | undefined;
    getIftrueExpression(): ExpressionAST | undefined;
    getColonToken(): Token | undefined;
    getIffalseExpression(): ExpressionAST | undefined;
}
export declare class ImplicitCastExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExpression(): ExpressionAST | undefined;
}
export declare class CastExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getRparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class CppCastExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCastToken(): Token | undefined;
    getLessToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getGreaterToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class NewExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getScopeToken(): Token | undefined;
    getNewToken(): Token | undefined;
    getTypeId(): NewTypeIdAST | undefined;
    getNewInitalizer(): NewInitializerAST | undefined;
}
export declare class DeleteExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getScopeToken(): Token | undefined;
    getDeleteToken(): Token | undefined;
    getLbracketToken(): Token | undefined;
    getRbracketToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class ThrowExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getThrowToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class NoexceptExpressionAST extends ExpressionAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getNoexceptToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class LabeledStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getIdentifierToken(): Token | undefined;
    getColonToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class CaseStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCaseToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getColonToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class DefaultStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDefaultToken(): Token | undefined;
    getColonToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class ExpressionStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class CompoundStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbraceToken(): Token | undefined;
    getStatementList(): Generator<StatementAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class IfStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getIfToken(): Token | undefined;
    getConstexprToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getInitializer(): StatementAST | undefined;
    getCondition(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
    getElseStatement(): StatementAST | undefined;
}
export declare class SwitchStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSwitchToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getInitializer(): StatementAST | undefined;
    getCondition(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class WhileStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getWhileToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getCondition(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class DoStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDoToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
    getWhileToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class ForRangeStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getForToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getInitializer(): StatementAST | undefined;
    getRangeDeclaration(): DeclarationAST | undefined;
    getColonToken(): Token | undefined;
    getRangeInitializer(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class ForStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getForToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getInitializer(): StatementAST | undefined;
    getCondition(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
    getStatement(): StatementAST | undefined;
}
export declare class BreakStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getBreakToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class ContinueStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getContinueToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class ReturnStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getReturnToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class GotoStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getGotoToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class CoroutineReturnStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getCoreturnToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class DeclarationStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDeclaration(): DeclarationAST | undefined;
}
export declare class TryBlockStatementAST extends StatementAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTryToken(): Token | undefined;
    getStatement(): CompoundStatementAST | undefined;
    getHandlerList(): Generator<HandlerAST | undefined>;
}
export declare class AccessDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAccessToken(): Token | undefined;
    getColonToken(): Token | undefined;
}
export declare class FunctionDefinitionAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getDeclSpecifierList(): Generator<SpecifierAST | undefined>;
    getDeclarator(): DeclaratorAST | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
    getFunctionBody(): FunctionBodyAST | undefined;
}
export declare class ConceptDefinitionAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getConceptToken(): Token | undefined;
    getName(): NameAST | undefined;
    getEqualToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class ForRangeDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class AliasDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getUsingToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getEqualToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class SimpleDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getDeclSpecifierList(): Generator<SpecifierAST | undefined>;
    getInitDeclaratorList(): Generator<InitDeclaratorAST | undefined>;
    getRequiresClause(): RequiresClauseAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class StaticAssertDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getStaticAssertToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getCommaToken(): Token | undefined;
    getRparenToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class EmptyDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSemicolonToken(): Token | undefined;
}
export declare class AttributeDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getSemicolonToken(): Token | undefined;
}
export declare class OpaqueEnumDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEnumToken(): Token | undefined;
    getClassToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getEnumBase(): EnumBaseAST | undefined;
    getEmicolonToken(): Token | undefined;
}
export declare class UsingEnumDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class NamespaceDefinitionAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getInlineToken(): Token | undefined;
    getNamespaceToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getExtraAttributeList(): Generator<AttributeAST | undefined>;
    getLbraceToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class NamespaceAliasDefinitionAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getNamespaceToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getEqualToken(): Token | undefined;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class UsingDirectiveAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getUsingToken(): Token | undefined;
    getNamespaceToken(): Token | undefined;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class UsingDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getUsingToken(): Token | undefined;
    getUsingDeclaratorList(): Generator<UsingDeclaratorAST | undefined>;
    getSemicolonToken(): Token | undefined;
}
export declare class AsmDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getAsmToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getRparenToken(): Token | undefined;
    getSemicolonToken(): Token | undefined;
}
export declare class ExportDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExportToken(): Token | undefined;
    getDeclaration(): DeclarationAST | undefined;
}
export declare class ExportCompoundDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExportToken(): Token | undefined;
    getLbraceToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class ModuleImportDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getImportToken(): Token | undefined;
    getImportName(): ImportNameAST | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getSemicolonToken(): Token | undefined;
}
export declare class TemplateDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTemplateToken(): Token | undefined;
    getLessToken(): Token | undefined;
    getTemplateParameterList(): Generator<DeclarationAST | undefined>;
    getGreaterToken(): Token | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
    getDeclaration(): DeclarationAST | undefined;
}
export declare class TypenameTypeParameterAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getClassKeyToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getEqualToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
}
export declare class TypenamePackTypeParameterAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getClassKeyToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
}
export declare class TemplateTypeParameterAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTemplateToken(): Token | undefined;
    getLessToken(): Token | undefined;
    getTemplateParameterList(): Generator<DeclarationAST | undefined>;
    getGreaterToken(): Token | undefined;
    getRequiresClause(): RequiresClauseAST | undefined;
    getClassKeyToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
    getEqualToken(): Token | undefined;
    getName(): NameAST | undefined;
}
export declare class TemplatePackTypeParameterAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTemplateToken(): Token | undefined;
    getLessToken(): Token | undefined;
    getTemplateParameterList(): Generator<DeclarationAST | undefined>;
    getGreaterToken(): Token | undefined;
    getClassKeyToken(): Token | undefined;
    getEllipsisToken(): Token | undefined;
    getIdentifierToken(): Token | undefined;
}
export declare class DeductionGuideAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class ExplicitInstantiationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExternToken(): Token | undefined;
    getTemplateToken(): Token | undefined;
    getDeclaration(): DeclarationAST | undefined;
}
export declare class ParameterDeclarationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getTypeSpecifierList(): Generator<SpecifierAST | undefined>;
    getDeclarator(): DeclaratorAST | undefined;
    getEqualToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
}
export declare class LinkageSpecificationAST extends DeclarationAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExternToken(): Token | undefined;
    getStringliteralToken(): Token | undefined;
    getLbraceToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class SimpleNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getIdentifierToken(): Token | undefined;
}
export declare class DestructorNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTildeToken(): Token | undefined;
    getId(): NameAST | undefined;
}
export declare class DecltypeNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDecltypeSpecifier(): SpecifierAST | undefined;
}
export declare class OperatorNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getOperatorToken(): Token | undefined;
    getOpToken(): Token | undefined;
    getOpenToken(): Token | undefined;
    getCloseToken(): Token | undefined;
}
export declare class ConversionNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getOperatorToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
}
export declare class TemplateNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getId(): NameAST | undefined;
    getLessToken(): Token | undefined;
    getTemplateArgumentList(): Generator<TemplateArgumentAST | undefined>;
    getGreaterToken(): Token | undefined;
}
export declare class QualifiedNameAST extends NameAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getTemplateToken(): Token | undefined;
    getId(): NameAST | undefined;
}
export declare class TypedefSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypedefToken(): Token | undefined;
}
export declare class FriendSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getFriendToken(): Token | undefined;
}
export declare class ConstevalSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getConstevalToken(): Token | undefined;
}
export declare class ConstinitSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getConstinitToken(): Token | undefined;
}
export declare class ConstexprSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getConstexprToken(): Token | undefined;
}
export declare class InlineSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getInlineToken(): Token | undefined;
}
export declare class StaticSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getStaticToken(): Token | undefined;
}
export declare class ExternSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExternToken(): Token | undefined;
}
export declare class ThreadLocalSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getThreadLocalToken(): Token | undefined;
}
export declare class ThreadSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getThreadToken(): Token | undefined;
}
export declare class MutableSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getMutableToken(): Token | undefined;
}
export declare class VirtualSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getVirtualToken(): Token | undefined;
}
export declare class ExplicitSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getExplicitToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class AutoTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAutoToken(): Token | undefined;
}
export declare class VoidTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getVoidToken(): Token | undefined;
}
export declare class VaListTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSpecifierToken(): Token | undefined;
}
export declare class IntegralTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSpecifierToken(): Token | undefined;
}
export declare class FloatingPointTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getSpecifierToken(): Token | undefined;
}
export declare class ComplexTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getComplexToken(): Token | undefined;
}
export declare class NamedTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getName(): NameAST | undefined;
}
export declare class AtomicTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getAtomicToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getTypeId(): TypeIdAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class UnderlyingTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
}
export declare class ElaboratedTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getClassToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
}
export declare class DecltypeAutoSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDecltypeToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getAutoToken(): Token | undefined;
    getRparenToken(): Token | undefined;
}
export declare class DecltypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getDecltypeToken(): Token | undefined;
    getLparenToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class PlaceholderTypeSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypeConstraint(): TypeConstraintAST | undefined;
    getSpecifier(): SpecifierAST | undefined;
}
export declare class ConstQualifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getConstToken(): Token | undefined;
}
export declare class VolatileQualifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getVolatileToken(): Token | undefined;
}
export declare class RestrictQualifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getRestrictToken(): Token | undefined;
}
export declare class EnumSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEnumToken(): Token | undefined;
    getClassToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
    getEnumBase(): EnumBaseAST | undefined;
    getLbraceToken(): Token | undefined;
    getCommaToken(): Token | undefined;
    getEnumeratorList(): Generator<EnumeratorAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class ClassSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getClassToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getName(): NameAST | undefined;
    getBaseClause(): BaseClauseAST | undefined;
    getLbraceToken(): Token | undefined;
    getDeclarationList(): Generator<DeclarationAST | undefined>;
    getRbraceToken(): Token | undefined;
}
export declare class TypenameSpecifierAST extends SpecifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getTypenameToken(): Token | undefined;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getName(): NameAST | undefined;
}
export declare class IdDeclaratorAST extends CoreDeclaratorAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getEllipsisToken(): Token | undefined;
    getName(): NameAST | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
}
export declare class NestedDeclaratorAST extends CoreDeclaratorAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLparenToken(): Token | undefined;
    getDeclarator(): DeclaratorAST | undefined;
    getRparenToken(): Token | undefined;
}
export declare class PointerOperatorAST extends PtrOperatorAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getStarToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getCvQualifierList(): Generator<SpecifierAST | undefined>;
}
export declare class ReferenceOperatorAST extends PtrOperatorAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getRefToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
}
export declare class PtrToMemberOperatorAST extends PtrOperatorAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getNestedNameSpecifier(): NestedNameSpecifierAST | undefined;
    getStarToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
    getCvQualifierList(): Generator<SpecifierAST | undefined>;
}
export declare class FunctionDeclaratorAST extends DeclaratorModifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getParametersAndQualifiers(): ParametersAndQualifiersAST | undefined;
    getTrailingReturnType(): TrailingReturnTypeAST | undefined;
}
export declare class ArrayDeclaratorAST extends DeclaratorModifierAST {
    accept<Context, Result>(visitor: ASTVisitor<Context, Result>, context: Context): Result;
    getLbracketToken(): Token | undefined;
    getExpression(): ExpressionAST | undefined;
    getRbracketToken(): Token | undefined;
    getAttributeList(): Generator<AttributeAST | undefined>;
}
