// Copyright (c) 2022 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
export var ASTKind;
(function (ASTKind) {
    // AST
    ASTKind[ASTKind["TypeId"] = 0] = "TypeId";
    ASTKind[ASTKind["NestedNameSpecifier"] = 1] = "NestedNameSpecifier";
    ASTKind[ASTKind["UsingDeclarator"] = 2] = "UsingDeclarator";
    ASTKind[ASTKind["Handler"] = 3] = "Handler";
    ASTKind[ASTKind["EnumBase"] = 4] = "EnumBase";
    ASTKind[ASTKind["Enumerator"] = 5] = "Enumerator";
    ASTKind[ASTKind["Declarator"] = 6] = "Declarator";
    ASTKind[ASTKind["InitDeclarator"] = 7] = "InitDeclarator";
    ASTKind[ASTKind["BaseSpecifier"] = 8] = "BaseSpecifier";
    ASTKind[ASTKind["BaseClause"] = 9] = "BaseClause";
    ASTKind[ASTKind["NewTypeId"] = 10] = "NewTypeId";
    ASTKind[ASTKind["RequiresClause"] = 11] = "RequiresClause";
    ASTKind[ASTKind["ParameterDeclarationClause"] = 12] = "ParameterDeclarationClause";
    ASTKind[ASTKind["ParametersAndQualifiers"] = 13] = "ParametersAndQualifiers";
    ASTKind[ASTKind["LambdaIntroducer"] = 14] = "LambdaIntroducer";
    ASTKind[ASTKind["LambdaDeclarator"] = 15] = "LambdaDeclarator";
    ASTKind[ASTKind["TrailingReturnType"] = 16] = "TrailingReturnType";
    ASTKind[ASTKind["CtorInitializer"] = 17] = "CtorInitializer";
    ASTKind[ASTKind["RequirementBody"] = 18] = "RequirementBody";
    ASTKind[ASTKind["TypeConstraint"] = 19] = "TypeConstraint";
    ASTKind[ASTKind["GlobalModuleFragment"] = 20] = "GlobalModuleFragment";
    ASTKind[ASTKind["PrivateModuleFragment"] = 21] = "PrivateModuleFragment";
    ASTKind[ASTKind["ModuleDeclaration"] = 22] = "ModuleDeclaration";
    ASTKind[ASTKind["ModuleName"] = 23] = "ModuleName";
    ASTKind[ASTKind["ImportName"] = 24] = "ImportName";
    ASTKind[ASTKind["ModulePartition"] = 25] = "ModulePartition";
    // RequirementAST
    ASTKind[ASTKind["SimpleRequirement"] = 26] = "SimpleRequirement";
    ASTKind[ASTKind["CompoundRequirement"] = 27] = "CompoundRequirement";
    ASTKind[ASTKind["TypeRequirement"] = 28] = "TypeRequirement";
    ASTKind[ASTKind["NestedRequirement"] = 29] = "NestedRequirement";
    // TemplateArgumentAST
    ASTKind[ASTKind["TypeTemplateArgument"] = 30] = "TypeTemplateArgument";
    ASTKind[ASTKind["ExpressionTemplateArgument"] = 31] = "ExpressionTemplateArgument";
    // MemInitializerAST
    ASTKind[ASTKind["ParenMemInitializer"] = 32] = "ParenMemInitializer";
    ASTKind[ASTKind["BracedMemInitializer"] = 33] = "BracedMemInitializer";
    // LambdaCaptureAST
    ASTKind[ASTKind["ThisLambdaCapture"] = 34] = "ThisLambdaCapture";
    ASTKind[ASTKind["DerefThisLambdaCapture"] = 35] = "DerefThisLambdaCapture";
    ASTKind[ASTKind["SimpleLambdaCapture"] = 36] = "SimpleLambdaCapture";
    ASTKind[ASTKind["RefLambdaCapture"] = 37] = "RefLambdaCapture";
    ASTKind[ASTKind["RefInitLambdaCapture"] = 38] = "RefInitLambdaCapture";
    ASTKind[ASTKind["InitLambdaCapture"] = 39] = "InitLambdaCapture";
    // InitializerAST
    ASTKind[ASTKind["EqualInitializer"] = 40] = "EqualInitializer";
    ASTKind[ASTKind["BracedInitList"] = 41] = "BracedInitList";
    ASTKind[ASTKind["ParenInitializer"] = 42] = "ParenInitializer";
    // NewInitializerAST
    ASTKind[ASTKind["NewParenInitializer"] = 43] = "NewParenInitializer";
    ASTKind[ASTKind["NewBracedInitializer"] = 44] = "NewBracedInitializer";
    // ExceptionDeclarationAST
    ASTKind[ASTKind["EllipsisExceptionDeclaration"] = 45] = "EllipsisExceptionDeclaration";
    ASTKind[ASTKind["TypeExceptionDeclaration"] = 46] = "TypeExceptionDeclaration";
    // FunctionBodyAST
    ASTKind[ASTKind["DefaultFunctionBody"] = 47] = "DefaultFunctionBody";
    ASTKind[ASTKind["CompoundStatementFunctionBody"] = 48] = "CompoundStatementFunctionBody";
    ASTKind[ASTKind["TryStatementFunctionBody"] = 49] = "TryStatementFunctionBody";
    ASTKind[ASTKind["DeleteFunctionBody"] = 50] = "DeleteFunctionBody";
    // UnitAST
    ASTKind[ASTKind["TranslationUnit"] = 51] = "TranslationUnit";
    ASTKind[ASTKind["ModuleUnit"] = 52] = "ModuleUnit";
    // ExpressionAST
    ASTKind[ASTKind["ThisExpression"] = 53] = "ThisExpression";
    ASTKind[ASTKind["CharLiteralExpression"] = 54] = "CharLiteralExpression";
    ASTKind[ASTKind["BoolLiteralExpression"] = 55] = "BoolLiteralExpression";
    ASTKind[ASTKind["IntLiteralExpression"] = 56] = "IntLiteralExpression";
    ASTKind[ASTKind["FloatLiteralExpression"] = 57] = "FloatLiteralExpression";
    ASTKind[ASTKind["NullptrLiteralExpression"] = 58] = "NullptrLiteralExpression";
    ASTKind[ASTKind["StringLiteralExpression"] = 59] = "StringLiteralExpression";
    ASTKind[ASTKind["UserDefinedStringLiteralExpression"] = 60] = "UserDefinedStringLiteralExpression";
    ASTKind[ASTKind["IdExpression"] = 61] = "IdExpression";
    ASTKind[ASTKind["RequiresExpression"] = 62] = "RequiresExpression";
    ASTKind[ASTKind["NestedExpression"] = 63] = "NestedExpression";
    ASTKind[ASTKind["RightFoldExpression"] = 64] = "RightFoldExpression";
    ASTKind[ASTKind["LeftFoldExpression"] = 65] = "LeftFoldExpression";
    ASTKind[ASTKind["FoldExpression"] = 66] = "FoldExpression";
    ASTKind[ASTKind["LambdaExpression"] = 67] = "LambdaExpression";
    ASTKind[ASTKind["SizeofExpression"] = 68] = "SizeofExpression";
    ASTKind[ASTKind["SizeofTypeExpression"] = 69] = "SizeofTypeExpression";
    ASTKind[ASTKind["SizeofPackExpression"] = 70] = "SizeofPackExpression";
    ASTKind[ASTKind["TypeidExpression"] = 71] = "TypeidExpression";
    ASTKind[ASTKind["TypeidOfTypeExpression"] = 72] = "TypeidOfTypeExpression";
    ASTKind[ASTKind["AlignofExpression"] = 73] = "AlignofExpression";
    ASTKind[ASTKind["TypeTraitsExpression"] = 74] = "TypeTraitsExpression";
    ASTKind[ASTKind["UnaryExpression"] = 75] = "UnaryExpression";
    ASTKind[ASTKind["BinaryExpression"] = 76] = "BinaryExpression";
    ASTKind[ASTKind["AssignmentExpression"] = 77] = "AssignmentExpression";
    ASTKind[ASTKind["BracedTypeConstruction"] = 78] = "BracedTypeConstruction";
    ASTKind[ASTKind["TypeConstruction"] = 79] = "TypeConstruction";
    ASTKind[ASTKind["CallExpression"] = 80] = "CallExpression";
    ASTKind[ASTKind["SubscriptExpression"] = 81] = "SubscriptExpression";
    ASTKind[ASTKind["MemberExpression"] = 82] = "MemberExpression";
    ASTKind[ASTKind["PostIncrExpression"] = 83] = "PostIncrExpression";
    ASTKind[ASTKind["ConditionalExpression"] = 84] = "ConditionalExpression";
    ASTKind[ASTKind["ImplicitCastExpression"] = 85] = "ImplicitCastExpression";
    ASTKind[ASTKind["CastExpression"] = 86] = "CastExpression";
    ASTKind[ASTKind["CppCastExpression"] = 87] = "CppCastExpression";
    ASTKind[ASTKind["NewExpression"] = 88] = "NewExpression";
    ASTKind[ASTKind["DeleteExpression"] = 89] = "DeleteExpression";
    ASTKind[ASTKind["ThrowExpression"] = 90] = "ThrowExpression";
    ASTKind[ASTKind["NoexceptExpression"] = 91] = "NoexceptExpression";
    // StatementAST
    ASTKind[ASTKind["LabeledStatement"] = 92] = "LabeledStatement";
    ASTKind[ASTKind["CaseStatement"] = 93] = "CaseStatement";
    ASTKind[ASTKind["DefaultStatement"] = 94] = "DefaultStatement";
    ASTKind[ASTKind["ExpressionStatement"] = 95] = "ExpressionStatement";
    ASTKind[ASTKind["CompoundStatement"] = 96] = "CompoundStatement";
    ASTKind[ASTKind["IfStatement"] = 97] = "IfStatement";
    ASTKind[ASTKind["SwitchStatement"] = 98] = "SwitchStatement";
    ASTKind[ASTKind["WhileStatement"] = 99] = "WhileStatement";
    ASTKind[ASTKind["DoStatement"] = 100] = "DoStatement";
    ASTKind[ASTKind["ForRangeStatement"] = 101] = "ForRangeStatement";
    ASTKind[ASTKind["ForStatement"] = 102] = "ForStatement";
    ASTKind[ASTKind["BreakStatement"] = 103] = "BreakStatement";
    ASTKind[ASTKind["ContinueStatement"] = 104] = "ContinueStatement";
    ASTKind[ASTKind["ReturnStatement"] = 105] = "ReturnStatement";
    ASTKind[ASTKind["GotoStatement"] = 106] = "GotoStatement";
    ASTKind[ASTKind["CoroutineReturnStatement"] = 107] = "CoroutineReturnStatement";
    ASTKind[ASTKind["DeclarationStatement"] = 108] = "DeclarationStatement";
    ASTKind[ASTKind["TryBlockStatement"] = 109] = "TryBlockStatement";
    // DeclarationAST
    ASTKind[ASTKind["AccessDeclaration"] = 110] = "AccessDeclaration";
    ASTKind[ASTKind["FunctionDefinition"] = 111] = "FunctionDefinition";
    ASTKind[ASTKind["ConceptDefinition"] = 112] = "ConceptDefinition";
    ASTKind[ASTKind["ForRangeDeclaration"] = 113] = "ForRangeDeclaration";
    ASTKind[ASTKind["AliasDeclaration"] = 114] = "AliasDeclaration";
    ASTKind[ASTKind["SimpleDeclaration"] = 115] = "SimpleDeclaration";
    ASTKind[ASTKind["StaticAssertDeclaration"] = 116] = "StaticAssertDeclaration";
    ASTKind[ASTKind["EmptyDeclaration"] = 117] = "EmptyDeclaration";
    ASTKind[ASTKind["AttributeDeclaration"] = 118] = "AttributeDeclaration";
    ASTKind[ASTKind["OpaqueEnumDeclaration"] = 119] = "OpaqueEnumDeclaration";
    ASTKind[ASTKind["UsingEnumDeclaration"] = 120] = "UsingEnumDeclaration";
    ASTKind[ASTKind["NamespaceDefinition"] = 121] = "NamespaceDefinition";
    ASTKind[ASTKind["NamespaceAliasDefinition"] = 122] = "NamespaceAliasDefinition";
    ASTKind[ASTKind["UsingDirective"] = 123] = "UsingDirective";
    ASTKind[ASTKind["UsingDeclaration"] = 124] = "UsingDeclaration";
    ASTKind[ASTKind["AsmDeclaration"] = 125] = "AsmDeclaration";
    ASTKind[ASTKind["ExportDeclaration"] = 126] = "ExportDeclaration";
    ASTKind[ASTKind["ExportCompoundDeclaration"] = 127] = "ExportCompoundDeclaration";
    ASTKind[ASTKind["ModuleImportDeclaration"] = 128] = "ModuleImportDeclaration";
    ASTKind[ASTKind["TemplateDeclaration"] = 129] = "TemplateDeclaration";
    ASTKind[ASTKind["TypenameTypeParameter"] = 130] = "TypenameTypeParameter";
    ASTKind[ASTKind["TypenamePackTypeParameter"] = 131] = "TypenamePackTypeParameter";
    ASTKind[ASTKind["TemplateTypeParameter"] = 132] = "TemplateTypeParameter";
    ASTKind[ASTKind["TemplatePackTypeParameter"] = 133] = "TemplatePackTypeParameter";
    ASTKind[ASTKind["DeductionGuide"] = 134] = "DeductionGuide";
    ASTKind[ASTKind["ExplicitInstantiation"] = 135] = "ExplicitInstantiation";
    ASTKind[ASTKind["ParameterDeclaration"] = 136] = "ParameterDeclaration";
    ASTKind[ASTKind["LinkageSpecification"] = 137] = "LinkageSpecification";
    // NameAST
    ASTKind[ASTKind["SimpleName"] = 138] = "SimpleName";
    ASTKind[ASTKind["DestructorName"] = 139] = "DestructorName";
    ASTKind[ASTKind["DecltypeName"] = 140] = "DecltypeName";
    ASTKind[ASTKind["OperatorName"] = 141] = "OperatorName";
    ASTKind[ASTKind["ConversionName"] = 142] = "ConversionName";
    ASTKind[ASTKind["TemplateName"] = 143] = "TemplateName";
    ASTKind[ASTKind["QualifiedName"] = 144] = "QualifiedName";
    // SpecifierAST
    ASTKind[ASTKind["TypedefSpecifier"] = 145] = "TypedefSpecifier";
    ASTKind[ASTKind["FriendSpecifier"] = 146] = "FriendSpecifier";
    ASTKind[ASTKind["ConstevalSpecifier"] = 147] = "ConstevalSpecifier";
    ASTKind[ASTKind["ConstinitSpecifier"] = 148] = "ConstinitSpecifier";
    ASTKind[ASTKind["ConstexprSpecifier"] = 149] = "ConstexprSpecifier";
    ASTKind[ASTKind["InlineSpecifier"] = 150] = "InlineSpecifier";
    ASTKind[ASTKind["StaticSpecifier"] = 151] = "StaticSpecifier";
    ASTKind[ASTKind["ExternSpecifier"] = 152] = "ExternSpecifier";
    ASTKind[ASTKind["ThreadLocalSpecifier"] = 153] = "ThreadLocalSpecifier";
    ASTKind[ASTKind["ThreadSpecifier"] = 154] = "ThreadSpecifier";
    ASTKind[ASTKind["MutableSpecifier"] = 155] = "MutableSpecifier";
    ASTKind[ASTKind["VirtualSpecifier"] = 156] = "VirtualSpecifier";
    ASTKind[ASTKind["ExplicitSpecifier"] = 157] = "ExplicitSpecifier";
    ASTKind[ASTKind["AutoTypeSpecifier"] = 158] = "AutoTypeSpecifier";
    ASTKind[ASTKind["VoidTypeSpecifier"] = 159] = "VoidTypeSpecifier";
    ASTKind[ASTKind["VaListTypeSpecifier"] = 160] = "VaListTypeSpecifier";
    ASTKind[ASTKind["IntegralTypeSpecifier"] = 161] = "IntegralTypeSpecifier";
    ASTKind[ASTKind["FloatingPointTypeSpecifier"] = 162] = "FloatingPointTypeSpecifier";
    ASTKind[ASTKind["ComplexTypeSpecifier"] = 163] = "ComplexTypeSpecifier";
    ASTKind[ASTKind["NamedTypeSpecifier"] = 164] = "NamedTypeSpecifier";
    ASTKind[ASTKind["AtomicTypeSpecifier"] = 165] = "AtomicTypeSpecifier";
    ASTKind[ASTKind["UnderlyingTypeSpecifier"] = 166] = "UnderlyingTypeSpecifier";
    ASTKind[ASTKind["ElaboratedTypeSpecifier"] = 167] = "ElaboratedTypeSpecifier";
    ASTKind[ASTKind["DecltypeAutoSpecifier"] = 168] = "DecltypeAutoSpecifier";
    ASTKind[ASTKind["DecltypeSpecifier"] = 169] = "DecltypeSpecifier";
    ASTKind[ASTKind["PlaceholderTypeSpecifier"] = 170] = "PlaceholderTypeSpecifier";
    ASTKind[ASTKind["ConstQualifier"] = 171] = "ConstQualifier";
    ASTKind[ASTKind["VolatileQualifier"] = 172] = "VolatileQualifier";
    ASTKind[ASTKind["RestrictQualifier"] = 173] = "RestrictQualifier";
    ASTKind[ASTKind["EnumSpecifier"] = 174] = "EnumSpecifier";
    ASTKind[ASTKind["ClassSpecifier"] = 175] = "ClassSpecifier";
    ASTKind[ASTKind["TypenameSpecifier"] = 176] = "TypenameSpecifier";
    // CoreDeclaratorAST
    ASTKind[ASTKind["IdDeclarator"] = 177] = "IdDeclarator";
    ASTKind[ASTKind["NestedDeclarator"] = 178] = "NestedDeclarator";
    // PtrOperatorAST
    ASTKind[ASTKind["PointerOperator"] = 179] = "PointerOperator";
    ASTKind[ASTKind["ReferenceOperator"] = 180] = "ReferenceOperator";
    ASTKind[ASTKind["PtrToMemberOperator"] = 181] = "PtrToMemberOperator";
    // DeclaratorModifierAST
    ASTKind[ASTKind["FunctionDeclarator"] = 182] = "FunctionDeclarator";
    ASTKind[ASTKind["ArrayDeclarator"] = 183] = "ArrayDeclarator";
})(ASTKind || (ASTKind = {}));
//# sourceMappingURL=ASTKind.js.map