import { AST } from "./AST.js";
interface ParseParams {
    /**
     * Path to the file to parse.
     */
    path: string;
    /**
     * Source code to parse.
     */
    source: string;
}
export declare class Parser {
    #private;
    static DEFAULT_WASM_BINARY_URL: URL;
    static init({ wasmBinary }: {
        wasmBinary: Uint8Array;
    }): Promise<import("./cxx.js").CXX>;
    constructor(options: ParseParams);
    parse(): void;
    dispose(): void;
    getUnitHandle(): number;
    getAST(): AST | undefined;
    getDiagnostics(): import("./Diagnostic.js").Diagnostic[];
}
export {};
